<div class="front_page_section front_page_section_about<?php
	$progress_scheme = progress_get_theme_option( 'front_page_about_scheme' );
	if ( ! empty( $progress_scheme ) && ! progress_is_inherit( $progress_scheme ) ) {
		echo ' scheme_' . esc_attr( $progress_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( progress_get_theme_option( 'front_page_about_paddings' ) );
	if ( progress_get_theme_option( 'front_page_about_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$progress_css      = '';
		$progress_bg_image = progress_get_theme_option( 'front_page_about_bg_image' );
		if ( ! empty( $progress_bg_image ) ) {
			$progress_css .= 'background-image: url(' . esc_url( progress_get_attachment_url( $progress_bg_image ) ) . ');';
		}
		if ( ! empty( $progress_css ) ) {
			echo ' style="' . esc_attr( $progress_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$progress_anchor_icon = progress_get_theme_option( 'front_page_about_anchor_icon' );
	$progress_anchor_text = progress_get_theme_option( 'front_page_about_anchor_text' );
if ( ( ! empty( $progress_anchor_icon ) || ! empty( $progress_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_about"'
									. ( ! empty( $progress_anchor_icon ) ? ' icon="' . esc_attr( $progress_anchor_icon ) . '"' : '' )
									. ( ! empty( $progress_anchor_text ) ? ' title="' . esc_attr( $progress_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_about_inner
	<?php
	if ( progress_get_theme_option( 'front_page_about_fullheight' ) ) {
		echo ' progress-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$progress_css           = '';
			$progress_bg_mask       = progress_get_theme_option( 'front_page_about_bg_mask' );
			$progress_bg_color_type = progress_get_theme_option( 'front_page_about_bg_color_type' );
			if ( 'custom' == $progress_bg_color_type ) {
				$progress_bg_color = progress_get_theme_option( 'front_page_about_bg_color' );
			} elseif ( 'scheme_bg_color' == $progress_bg_color_type ) {
				$progress_bg_color = progress_get_scheme_color( 'bg_color', $progress_scheme );
			} else {
				$progress_bg_color = '';
			}
			if ( ! empty( $progress_bg_color ) && $progress_bg_mask > 0 ) {
				$progress_css .= 'background-color: ' . esc_attr(
					1 == $progress_bg_mask ? $progress_bg_color : progress_hex2rgba( $progress_bg_color, $progress_bg_mask )
				) . ';';
			}
			if ( ! empty( $progress_css ) ) {
				echo ' style="' . esc_attr( $progress_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_about_content_wrap content_wrap">
			<?php
			// Caption
			$progress_caption = progress_get_theme_option( 'front_page_about_caption' );
			if ( ! empty( $progress_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_about_caption front_page_block_<?php echo ! empty( $progress_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $progress_caption, 'progress_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$progress_description = progress_get_theme_option( 'front_page_about_description' );
			if ( ! empty( $progress_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_about_description front_page_block_<?php echo ! empty( $progress_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $progress_description ), 'progress_kses_content' ); ?></div>
				<?php
			}

			// Content
			$progress_content = progress_get_theme_option( 'front_page_about_content' );
			if ( ! empty( $progress_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_content front_page_section_about_content front_page_block_<?php echo ! empty( $progress_content ) ? 'filled' : 'empty'; ?>">
					<?php
					$progress_page_content_mask = '%%CONTENT%%';
					if ( strpos( $progress_content, $progress_page_content_mask ) !== false ) {
						$progress_content = preg_replace(
							'/(\<p\>\s*)?' . $progress_page_content_mask . '(\s*\<\/p\>)/i',
							sprintf(
								'<div class="front_page_section_about_source">%s</div>',
								apply_filters( 'the_content', get_the_content() )
							),
							$progress_content
						);
					}
					progress_show_layout( $progress_content );
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
