<?php
$progress_slider_sc = progress_get_theme_option( 'front_page_title_shortcode' );
if ( ! empty( $progress_slider_sc ) && strpos( $progress_slider_sc, '[' ) !== false && strpos( $progress_slider_sc, ']' ) !== false ) {

	?><div class="front_page_section front_page_section_title front_page_section_slider front_page_section_title_slider
		<?php
		if ( progress_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
	">
	<?php
		// Add anchor
		$progress_anchor_icon = progress_get_theme_option( 'front_page_title_anchor_icon' );
		$progress_anchor_text = progress_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $progress_anchor_icon ) || ! empty( $progress_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $progress_anchor_icon ) ? ' icon="' . esc_attr( $progress_anchor_icon ) . '"' : '' )
									. ( ! empty( $progress_anchor_text ) ? ' title="' . esc_attr( $progress_anchor_text ) . '"' : '' )
									. ']'
		);
	}
		// Show slider (or any other content, generated by shortcode)
		echo do_shortcode( $progress_slider_sc );
	?>
	</div>
	<?php

} else {

	?>
	<div class="front_page_section front_page_section_title
		<?php
		$progress_scheme = progress_get_theme_option( 'front_page_title_scheme' );
		if ( ! empty( $progress_scheme ) && ! progress_is_inherit( $progress_scheme ) ) {
			echo ' scheme_' . esc_attr( $progress_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( progress_get_theme_option( 'front_page_title_paddings' ) );
		if ( progress_get_theme_option( 'front_page_title_stack' ) ) {
			echo ' sc_stack_section_on';
		}
		?>
		"
		<?php
		$progress_css      = '';
		$progress_bg_image = progress_get_theme_option( 'front_page_title_bg_image' );
		if ( ! empty( $progress_bg_image ) ) {
			$progress_css .= 'background-image: url(' . esc_url( progress_get_attachment_url( $progress_bg_image ) ) . ');';
		}
		if ( ! empty( $progress_css ) ) {
			echo ' style="' . esc_attr( $progress_css ) . '"';
		}
		?>
	>
	<?php
		// Add anchor
		$progress_anchor_icon = progress_get_theme_option( 'front_page_title_anchor_icon' );
		$progress_anchor_text = progress_get_theme_option( 'front_page_title_anchor_text' );
	if ( ( ! empty( $progress_anchor_icon ) || ! empty( $progress_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
		echo do_shortcode(
			'[trx_sc_anchor id="front_page_section_title"'
									. ( ! empty( $progress_anchor_icon ) ? ' icon="' . esc_attr( $progress_anchor_icon ) . '"' : '' )
									. ( ! empty( $progress_anchor_text ) ? ' title="' . esc_attr( $progress_anchor_text ) . '"' : '' )
									. ']'
		);
	}
	?>
		<div class="front_page_section_inner front_page_section_title_inner
		<?php
		if ( progress_get_theme_option( 'front_page_title_fullheight' ) ) {
			echo ' progress-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
			"
			<?php
			$progress_css      = '';
			$progress_bg_mask  = progress_get_theme_option( 'front_page_title_bg_mask' );
			$progress_bg_color_type = progress_get_theme_option( 'front_page_title_bg_color_type' );
			if ( 'custom' == $progress_bg_color_type ) {
				$progress_bg_color = progress_get_theme_option( 'front_page_title_bg_color' );
			} elseif ( 'scheme_bg_color' == $progress_bg_color_type ) {
				$progress_bg_color = progress_get_scheme_color( 'bg_color', $progress_scheme );
			} else {
				$progress_bg_color = '';
			}
			if ( ! empty( $progress_bg_color ) && $progress_bg_mask > 0 ) {
				$progress_css .= 'background-color: ' . esc_attr(
					1 == $progress_bg_mask ? $progress_bg_color : progress_hex2rgba( $progress_bg_color, $progress_bg_mask )
				) . ';';
			}
			if ( ! empty( $progress_css ) ) {
				echo ' style="' . esc_attr( $progress_css ) . '"';
			}
			?>
		>
			<div class="front_page_section_content_wrap front_page_section_title_content_wrap content_wrap">
				<?php
				// Caption
				$progress_caption = progress_get_theme_option( 'front_page_title_caption' );
				if ( ! empty( $progress_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h1 class="front_page_section_caption front_page_section_title_caption front_page_block_<?php echo ! empty( $progress_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $progress_caption, 'progress_kses_content' ); ?></h1>
					<?php
				}

				// Description (text)
				$progress_description = progress_get_theme_option( 'front_page_title_description' );
				if ( ! empty( $progress_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_title_description front_page_block_<?php echo ! empty( $progress_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $progress_description ), 'progress_kses_content' ); ?></div>
					<?php
				}

				// Buttons
				if ( progress_get_theme_option( 'front_page_title_button1_link' ) != '' || progress_get_theme_option( 'front_page_title_button2_link' ) != '' ) {
					?>
					<div class="front_page_section_buttons front_page_section_title_buttons">
					<?php
						progress_show_layout( progress_customizer_partial_refresh_front_page_title_button1_link() );
						progress_show_layout( progress_customizer_partial_refresh_front_page_title_button2_link() );
					?>
					</div>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
}
