<?php
/**
 * The Header: Logo and main menu
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js<?php
	// Class scheme_xxx need in the <html> as context for the <body>!
	echo ' scheme_' . esc_attr( progress_get_theme_option( 'color_scheme' ) );
?>">

<head>
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

	<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	}
	do_action( 'progress_action_before_body' );
	?>

	<div class="<?php echo esc_attr( apply_filters( 'progress_filter_body_wrap_class', 'body_wrap' ) ); ?>" <?php do_action('progress_action_body_wrap_attributes'); ?>>

		<?php do_action( 'progress_action_before_page_wrap' ); ?>

		<div class="<?php echo esc_attr( apply_filters( 'progress_filter_page_wrap_class', 'page_wrap' ) ); ?>" <?php do_action('progress_action_page_wrap_attributes'); ?>>

			<?php do_action( 'progress_action_page_wrap_start' ); ?>

			<?php
			$progress_full_post_loading = ( progress_is_singular( 'post' ) || progress_is_singular( 'attachment' ) ) && progress_get_value_gp( 'action' ) == 'full_post_loading';
			$progress_prev_post_loading = ( progress_is_singular( 'post' ) || progress_is_singular( 'attachment' ) ) && progress_get_value_gp( 'action' ) == 'prev_post_loading';

			// Don't display the header elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ! $progress_full_post_loading && ! $progress_prev_post_loading ) {

				// Short links to fast access to the content, sidebar and footer from the keyboard
				?>
				<a class="progress_skip_link skip_to_content_link" href="#content_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'progress_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to content", 'progress' ); ?></a>
				<?php if ( progress_sidebar_present() ) { ?>
				<a class="progress_skip_link skip_to_sidebar_link" href="#sidebar_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'progress_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to sidebar", 'progress' ); ?></a>
				<?php } ?>
				<a class="progress_skip_link skip_to_footer_link" href="#footer_skip_link_anchor" tabindex="<?php echo esc_attr( apply_filters( 'progress_filter_skip_links_tabindex', 1 ) ); ?>"><?php esc_html_e( "Skip to footer", 'progress' ); ?></a>

				<?php
				do_action( 'progress_action_before_header' );

				// Header
				$progress_header_type = progress_get_theme_option( 'header_type' );
				if ( 'custom' == $progress_header_type && ! progress_is_layouts_available() ) {
					$progress_header_type = 'default';
				}
				get_template_part( apply_filters( 'progress_filter_get_template_part', "templates/header-" . sanitize_file_name( $progress_header_type ) ) );

				// Side menu
				if ( in_array( progress_get_theme_option( 'menu_side', 'none' ), array( 'left', 'right' ) ) ) {
					get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/header-navi-side' ) );
				}

				// Mobile menu
				if ( apply_filters( 'progress_filter_use_navi_mobile', true ) ) {
					get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/header-navi-mobile' ) );
				}

				do_action( 'progress_action_after_header' );

			}
			?>

			<?php do_action( 'progress_action_before_page_content_wrap' ); ?>

			<div class="page_content_wrap<?php
				if ( progress_is_off( progress_get_theme_option( 'remove_margins' ) ) ) {
					if ( empty( $progress_header_type ) ) {
						$progress_header_type = progress_get_theme_option( 'header_type' );
					}
					if ( 'custom' == $progress_header_type && progress_is_layouts_available() ) {
						$progress_header_id = progress_get_custom_header_id();
						if ( $progress_header_id > 0 ) {
							$progress_header_meta = progress_get_custom_layout_meta( $progress_header_id );
							if ( ! empty( $progress_header_meta['margin'] ) ) {
								?> page_content_wrap_custom_header_margin<?php
							}
						}
					}
					$progress_footer_type = progress_get_theme_option( 'footer_type' );
					if ( 'custom' == $progress_footer_type && progress_is_layouts_available() ) {
						$progress_footer_id = progress_get_custom_footer_id();
						if ( $progress_footer_id ) {
							$progress_footer_meta = progress_get_custom_layout_meta( $progress_footer_id );
							if ( ! empty( $progress_footer_meta['margin'] ) ) {
								?> page_content_wrap_custom_footer_margin<?php
							}
						}
					}
				}
				do_action( 'progress_action_page_content_wrap_class', $progress_prev_post_loading );
				?>"<?php
				if ( apply_filters( 'progress_filter_is_prev_post_loading', $progress_prev_post_loading ) ) {
					?> data-single-style="<?php echo esc_attr( progress_get_theme_option( 'single_style' ) ); ?>"<?php
				}
				do_action( 'progress_action_page_content_wrap_data', $progress_prev_post_loading );
			?>>
				<?php
				do_action( 'progress_action_page_content_wrap', $progress_full_post_loading || $progress_prev_post_loading );

				// Single posts banner
				if ( apply_filters( 'progress_filter_single_post_header', progress_is_singular( 'post' ) || progress_is_singular( 'attachment' ) ) ) {
					if ( $progress_prev_post_loading ) {
						if ( progress_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) != 'article' ) {
							do_action( 'progress_action_between_posts' );
						}
					}
					// Single post thumbnail and title
					$progress_path = apply_filters( 'progress_filter_get_template_part', 'templates/single-styles/' . progress_get_theme_option( 'single_style' ) );
					if ( progress_get_file_dir( $progress_path . '.php' ) != '' ) {
						get_template_part( $progress_path );
					}
				}

				// Widgets area above page
				$progress_body_style   = progress_get_theme_option( 'body_style' );
				$progress_widgets_name = progress_get_theme_option( 'widgets_above_page', 'hide' );
				$progress_show_widgets = ! progress_is_off( $progress_widgets_name ) && is_active_sidebar( $progress_widgets_name );
				if ( $progress_show_widgets ) {
					if ( 'fullscreen' != $progress_body_style ) {
						?>
						<div class="content_wrap">
							<?php
					}
					progress_create_widgets_area( 'widgets_above_page' );
					if ( 'fullscreen' != $progress_body_style ) {
						?>
						</div>
						<?php
					}
				}

				// Content area
				do_action( 'progress_action_before_content_wrap' );
				?>
				<div class="content_wrap<?php echo 'fullscreen' == $progress_body_style ? '_fullscreen' : ''; ?>">

					<?php do_action( 'progress_action_content_wrap_start' ); ?>

					<div class="content">
						<?php
						do_action( 'progress_action_page_content_start' );

						// Skip link anchor to fast access to the content from keyboard
						?>
						<a id="content_skip_link_anchor" class="progress_skip_link_anchor" href="#"></a>
						<?php
						// Single posts banner between prev/next posts
						if ( ( progress_is_singular( 'post' ) || progress_is_singular( 'attachment' ) )
							&& $progress_prev_post_loading 
							&& progress_get_theme_option( 'posts_navigation_scroll_which_block', 'article' ) == 'article'
						) {
							do_action( 'progress_action_between_posts' );
						}

						// Widgets area above content
						progress_create_widgets_area( 'widgets_above_content' );

						do_action( 'progress_action_page_content_start_text' );
