<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 * Learn more: //codex.wordpress.org/Template_Hierarchy
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

$progress_template = apply_filters( 'progress_filter_get_template_part', progress_blog_archive_get_template() );

if ( ! empty( $progress_template ) && 'index' != $progress_template ) {

	get_template_part( $progress_template );

} else {

	progress_storage_set( 'blog_archive', true );

	get_header();

	if ( have_posts() ) {

		// Query params
		$progress_stickies   = is_home()
								|| ( in_array( progress_get_theme_option( 'post_type' ), array( '', 'post' ) )
									&& (int) progress_get_theme_option( 'parent_cat' ) == 0
									)
										? get_option( 'sticky_posts' )
										: false;
		$progress_post_type  = progress_get_theme_option( 'post_type' );
		$progress_args       = array(
								'blog_style'     => progress_get_theme_option( 'blog_style' ),
								'post_type'      => $progress_post_type,
								'taxonomy'       => progress_get_post_type_taxonomy( $progress_post_type ),
								'parent_cat'     => progress_get_theme_option( 'parent_cat' ),
								'posts_per_page' => progress_get_theme_option( 'posts_per_page' ),
								'sticky'         => progress_get_theme_option( 'sticky_style', 'inherit' ) == 'columns'
															&& is_array( $progress_stickies )
															&& count( $progress_stickies ) > 0
															&& get_query_var( 'paged' ) < 1
								);

		progress_blog_archive_start();

		do_action( 'progress_action_blog_archive_start' );

		if ( is_author() ) {
			do_action( 'progress_action_before_page_author' );
			get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/author-page' ) );
			do_action( 'progress_action_after_page_author' );
		}

		if ( progress_get_theme_option( 'show_filters', 0 ) ) {
			do_action( 'progress_action_before_page_filters' );
			progress_show_filters( $progress_args );
			do_action( 'progress_action_after_page_filters' );
		} else {
			do_action( 'progress_action_before_page_posts' );
			progress_show_posts( array_merge( $progress_args, array( 'cat' => $progress_args['parent_cat'] ) ) );
			do_action( 'progress_action_after_page_posts' );
		}

		do_action( 'progress_action_blog_archive_end' );

		progress_blog_archive_end();

	} else {

		if ( is_search() ) {
			get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/content', 'none-search' ), 'none-search' );
		} else {
			get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/content', 'none-archive' ), 'none-archive' );
		}
	}

	get_footer();
}
