<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

if ( progress_sidebar_present() ) {
	
	$progress_sidebar_type = progress_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $progress_sidebar_type && ! progress_is_layouts_available() ) {
		$progress_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $progress_sidebar_type ) {
		// Default sidebar with widgets
		$progress_sidebar_name = progress_get_theme_option( 'sidebar_widgets' );
		progress_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $progress_sidebar_name ) ) {
			dynamic_sidebar( $progress_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$progress_sidebar_id = progress_get_custom_sidebar_id();
		do_action( 'progress_action_show_layout', $progress_sidebar_id );
	}
	$progress_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $progress_out ) ) {
		$progress_sidebar_position    = progress_get_theme_option( 'sidebar_position' );
		$progress_sidebar_position_ss = progress_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $progress_sidebar_position );
			echo ' sidebar_' . esc_attr( $progress_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $progress_sidebar_type );

			$progress_sidebar_scheme = apply_filters( 'progress_filter_sidebar_scheme', progress_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $progress_sidebar_scheme ) && ! progress_is_inherit( $progress_sidebar_scheme ) && 'custom' != $progress_sidebar_type ) {
				echo ' scheme_' . esc_attr( $progress_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="progress_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'progress_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $progress_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$progress_title = apply_filters( 'progress_filter_sidebar_control_title', 'float' == $progress_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'progress' ) : '' );
				$progress_text  = apply_filters( 'progress_filter_sidebar_control_text', 'above' == $progress_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'progress' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $progress_title ); ?>"><?php echo esc_html( $progress_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'progress_action_before_sidebar', 'sidebar' );
				progress_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $progress_out ) );
				do_action( 'progress_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'progress_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
