<?php
/**
 * The template to display single post
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

// Full post loading
$full_post_loading          = progress_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = progress_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = progress_get_theme_option( 'posts_navigation_scroll_which_block', 'article' );

// Position of the related posts
$progress_related_position   = progress_get_theme_option( 'related_position', 'below_content' );

// Type of the prev/next post navigation
$progress_posts_navigation   = progress_get_theme_option( 'posts_navigation' );
$progress_prev_post          = false;
$progress_prev_post_same_cat = (int)progress_get_theme_option( 'posts_navigation_scroll_same_cat', 1 );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( progress_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	progress_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'progress_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $progress_posts_navigation ) {
		$progress_prev_post = get_previous_post( $progress_prev_post_same_cat );  // Get post from same category
		if ( ! $progress_prev_post && $progress_prev_post_same_cat ) {
			$progress_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $progress_prev_post ) {
			$progress_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $progress_prev_post ) ) {
		progress_sc_layouts_showed( 'featured', false );
		progress_sc_layouts_showed( 'title', false );
		progress_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $progress_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/content', 'single-' . progress_get_theme_option( 'single_style' ) ), 'single-' . progress_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $progress_related_position, 'inside' ) === 0 ) {
		$progress_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'progress_action_related_posts' );
		$progress_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $progress_related_content ) ) {
			$progress_related_position_inside = max( 0, min( 9, progress_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $progress_related_position_inside ) {
				$progress_related_position_inside = mt_rand( 1, 9 );
			}

			$progress_p_number         = 0;
			$progress_related_inserted = false;
			$progress_in_block         = false;
			$progress_content_start    = strpos( $progress_content, '<div class="post_content' );
			$progress_content_end      = strrpos( $progress_content, '</div>' );

			for ( $i = max( 0, $progress_content_start ); $i < min( strlen( $progress_content ) - 3, $progress_content_end ); $i++ ) {
				if ( $progress_content[ $i ] != '<' ) {
					continue;
				}
				if ( $progress_in_block ) {
					if ( strtolower( substr( $progress_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$progress_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $progress_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $progress_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$progress_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $progress_content[ $i + 1 ] && in_array( $progress_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$progress_p_number++;
					if ( $progress_related_position_inside == $progress_p_number ) {
						$progress_related_inserted = true;
						$progress_content = ( $i > 0 ? substr( $progress_content, 0, $i ) : '' )
											. $progress_related_content
											. substr( $progress_content, $i );
					}
				}
			}
			if ( ! $progress_related_inserted ) {
				if ( $progress_content_end > 0 ) {
					$progress_content = substr( $progress_content, 0, $progress_content_end ) . $progress_related_content . substr( $progress_content, $progress_content_end );
				} else {
					$progress_content .= $progress_related_content;
				}
			}
		}

		progress_show_layout( $progress_content );
	}

	// Comments
	do_action( 'progress_action_before_comments' );
	comments_template();
	do_action( 'progress_action_after_comments' );

	// Related posts
	if ( 'below_content' == $progress_related_position
		&& ( 'scroll' != $progress_posts_navigation || (int)progress_get_theme_option( 'posts_navigation_scroll_hide_related', 0 ) == 0 )
		&& ( ! $full_post_loading || (int)progress_get_theme_option( 'open_full_post_hide_related', 1 ) == 0 )
	) {
		do_action( 'progress_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $progress_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $progress_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $progress_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $progress_prev_post ) ); ?>"
			data-cur-post-link="<?php echo esc_attr( get_permalink() ); ?>"
			data-cur-post-title="<?php the_title_attribute(); ?>"
			<?php do_action( 'progress_action_nav_links_single_scroll_data', $progress_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
