<?php
/* Twenty20 Image Before-After support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('progress_twenty20_theme_setup9')) {
	add_action( 'after_setup_theme', 'progress_twenty20_theme_setup9', 9 );
	function progress_twenty20_theme_setup9() {
		if (is_admin()) {
			add_filter( 'progress_filter_tgmpa_required_plugins',		'progress_twenty20_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'progress_twenty20_tgmpa_required_plugins' ) ) {
	function progress_twenty20_tgmpa_required_plugins($list=array()) {
		if (progress_storage_isset('required_plugins', 'twenty20') && progress_storage_get_array( 'required_plugins', 'twenty20', 'install' ) !== false) {
			$list[] = array(
				'name' 		=> progress_storage_get_array('required_plugins', 'twenty20', 'title'),
				'slug' 		=> 'twenty20',
				'required' 	=> false
			);
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'progress_exists_twenty20' ) ) {
	function progress_exists_twenty20() {
		return function_exists('twenty20_dir_init');
	}
}

?>