<?php
/**
 * Required plugins
 *
 * @package PROGRESS
 * @since PROGRESS 1.76.0
 */

// THEME-SUPPORTED PLUGINS
// If plugin not need - remove its settings from next array
//----------------------------------------------------------
$progress_theme_required_plugins_groups = array(
	'core'          => esc_html__( 'Core', 'progress' ),
	'page_builders' => esc_html__( 'Page Builders', 'progress' ),
	'ecommerce'     => esc_html__( 'E-Commerce & Donations', 'progress' ),
	'socials'       => esc_html__( 'Socials and Communities', 'progress' ),
	'events'        => esc_html__( 'Events and Appointments', 'progress' ),
	'content'       => esc_html__( 'Content', 'progress' ),
	'other'         => esc_html__( 'Other', 'progress' ),
);
$progress_theme_required_plugins        = array(
	'trx_addons'                 => array(
		'title'       => esc_html__( 'ThemeREX Addons', 'progress' ),
		'description' => esc_html__( "Will allow you to install recommended plugins, demo content, and improve the theme's functionality overall with multiple theme options", 'progress' ),
		'required'    => true,
		'logo'        => 'trx_addons.png',
		'group'       => $progress_theme_required_plugins_groups['core'],
	),
	'elementor'                  => array(
		'title'       => esc_html__( 'Elementor', 'progress' ),
		'description' => esc_html__( "Is a beautiful PageBuilder, even the free version of which allows you to create great pages using a variety of modules.", 'progress' ),
		'required'    => false,
		'logo'        => 'elementor.png',
		'group'       => $progress_theme_required_plugins_groups['page_builders'],
	),
	'gutenberg'                  => array(
		'title'       => esc_html__( 'Gutenberg', 'progress' ),
		'description' => esc_html__( "It's a posts editor coming in place of the classic TinyMCE. Can be installed and used in parallel with Elementor", 'progress' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'gutenberg.png',
		'group'       => $progress_theme_required_plugins_groups['page_builders'],
	),
	'js_composer'                => array(
		'title'       => esc_html__( 'WPBakery PageBuilder', 'progress' ),
		'description' => esc_html__( "Popular PageBuilder which allows you to create excellent pages", 'progress' ),
		'required'    => false,
		'install'     => false,          // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'js_composer.jpg',
		'group'       => $progress_theme_required_plugins_groups['page_builders'],
	),
	'woocommerce'                => array(
		'title'       => esc_html__( 'WooCommerce', 'progress' ),
		'description' => esc_html__( "Connect the store to your website and start selling now", 'progress' ),
		'required'    => false,
		'logo'        => 'woocommerce.png',
		'group'       => $progress_theme_required_plugins_groups['ecommerce'],
	),
	'elegro-payment'             => array(
		'title'       => esc_html__( 'Elegro Crypto Payment', 'progress' ),
		'description' => esc_html__( "Extends WooCommerce Payment Gateways with an elegro Crypto Payment", 'progress' ),
		'required'    => false,
		'install'     => false, // TRX_addons has marked the "Elegro Crypto Payment" plugin as obsolete and no longer recommends it for installation, even if it had been previously recommended by the theme
		'logo'        => 'elegro-payment.png',
		'group'       => $progress_theme_required_plugins_groups['ecommerce'],
	),
	'give'                       => array(
		'title'       => esc_html__( 'Give', 'progress' ),
		'description' => '',
		'required'    => false,
		'logo'        => progress_get_file_url( 'plugins/give/give.png' ),
		'group'       => $progress_theme_required_plugins_groups['ecommerce'],
	),
	'instagram-feed'             => array(
		'title'       => esc_html__( 'Instagram Feed', 'progress' ),
		'description' => esc_html__( "Displays the latest photos from your profile on Instagram", 'progress' ),
		'required'    => false,
		'logo'        => 'instagram-feed.png',
		'group'       => $progress_theme_required_plugins_groups['socials'],
	),
	'mailchimp-for-wp'           => array(
		'title'       => esc_html__( 'MailChimp for WP', 'progress' ),
		'description' => esc_html__( "Allows visitors to subscribe to newsletters", 'progress' ),
		'required'    => false,
		'logo'        => 'mailchimp-for-wp.png',
		'group'       => $progress_theme_required_plugins_groups['socials'],
	),
	'booked'                     => array(
		'title'       => esc_html__( 'Booked Appointments', 'progress' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'booked.png',
		'group'       => $progress_theme_required_plugins_groups['events'],
	),
	'quickcal'                     => array(
		'title'       => esc_html__( 'QuickCal', 'progress' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'quickcal.png',
		'group'       => $progress_theme_required_plugins_groups['events'],
	),
	'the-events-calendar'        => array(
		'title'       => esc_html__( 'The Events Calendar', 'progress' ),
		'description' => '',
		'required'    => false,
		'logo'        => 'the-events-calendar.png',
		'group'       => $progress_theme_required_plugins_groups['events'],
	),
	'contact-form-7'             => array(
		'title'       => esc_html__( 'Contact Form 7', 'progress' ),
		'description' => esc_html__( "CF7 allows you to create an unlimited number of contact forms", 'progress' ),
		'required'    => false,
		'logo'        => 'contact-form-7.png',
		'group'       => $progress_theme_required_plugins_groups['content'],
	),

	'latepoint'                  => array(
		'title'       => esc_html__( 'LatePoint', 'progress' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => progress_get_file_url( 'plugins/latepoint/latepoint.png' ),
		'group'       => $progress_theme_required_plugins_groups['events'],
	),
	'advanced-popups'                  => array(
		'title'       => esc_html__( 'Advanced Popups', 'progress' ),
		'description' => '',
		'required'    => false,
		'logo'        => progress_get_file_url( 'plugins/advanced-popups/advanced-popups.jpg' ),
		'group'       => $progress_theme_required_plugins_groups['content'],
	),
	'devvn-image-hotspot'                  => array(
		'title'       => esc_html__( 'Image Hotspot by DevVN', 'progress' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => progress_get_file_url( 'plugins/devvn-image-hotspot/devvn-image-hotspot.png' ),
		'group'       => $progress_theme_required_plugins_groups['content'],
	),
	'ti-woocommerce-wishlist'                  => array(
		'title'       => esc_html__( 'TI WooCommerce Wishlist', 'progress' ),
		'description' => '',
		'required'    => false,
		'logo'        => progress_get_file_url( 'plugins/ti-woocommerce-wishlist/ti-woocommerce-wishlist.png' ),
		'group'       => $progress_theme_required_plugins_groups['ecommerce'],
	),
	'woo-smart-quick-view'                  => array(
		'title'       => esc_html__( 'WPC Smart Quick View for WooCommerce', 'progress' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => progress_get_file_url( 'plugins/woo-smart-quick-view/woo-smart-quick-view.png' ),
		'group'       => $progress_theme_required_plugins_groups['ecommerce'],
	),
	'twenty20'                  => array(
		'title'       => esc_html__( 'Twenty20 Image Before-After', 'progress' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => progress_get_file_url( 'plugins/twenty20/twenty20.png' ),
		'group'       => $progress_theme_required_plugins_groups['content'],
	),
	'essential-grid'             => array(
		'title'       => esc_html__( 'Essential Grid', 'progress' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'essential-grid.png',
		'group'       => $progress_theme_required_plugins_groups['content'],
	),
	'revslider'                  => array(
		'title'       => esc_html__( 'Revolution Slider', 'progress' ),
		'description' => '',
		'required'    => false,
		'install'     => false,
		'logo'        => 'revslider.png',
		'group'       => $progress_theme_required_plugins_groups['content'],
	),
	'sitepress-multilingual-cms' => array(
		'title'       => esc_html__( 'WPML - Sitepress Multilingual CMS', 'progress' ),
		'description' => esc_html__( "Allows you to make your website multilingual", 'progress' ),
		'required'    => false,
		'install'     => false,      // Do not offer installation of the plugin in the Theme Dashboard and TGMPA
		'logo'        => 'sitepress-multilingual-cms.png',
		'group'       => $progress_theme_required_plugins_groups['content'],
	),
	'wp-gdpr-compliance'         => array(
		'title'       => esc_html__( 'Cookie Information', 'progress' ),
		'description' => esc_html__( "Allow visitors to decide for themselves what personal data they want to store on your site", 'progress' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'wp-gdpr-compliance.png',
		'group'       => $progress_theme_required_plugins_groups['other'],
	),
	'gdpr-framework'         => array(
		'title'       => esc_html__( 'The GDPR Framework', 'progress' ),
		'description' => esc_html__( "Tools to help make your website GDPR-compliant. Fully documented, extendable and developer-friendly.", 'progress' ),
		'required'    => false,
		'install'     => false,
		'logo'        => 'gdpr-framework.png',
		'group'       => $progress_theme_required_plugins_groups['other'],
	),
	'trx_updater'                => array(
		'title'       => esc_html__( 'ThemeREX Updater', 'progress' ),
		'description' => esc_html__( "Update theme and theme-specific plugins from developer's upgrade server.", 'progress' ),
		'required'    => false,
		'logo'        => 'trx_updater.png',
		'group'       => $progress_theme_required_plugins_groups['other'],
	),
);

if ( PROGRESS_THEME_FREE ) {
	unset( $progress_theme_required_plugins['js_composer'] );
	unset( $progress_theme_required_plugins['booked'] );
	unset( $progress_theme_required_plugins['quickcal'] );
	unset( $progress_theme_required_plugins['the-events-calendar'] );
	unset( $progress_theme_required_plugins['calculated-fields-form'] );
	unset( $progress_theme_required_plugins['essential-grid'] );
	unset( $progress_theme_required_plugins['revslider'] );
	unset( $progress_theme_required_plugins['sitepress-multilingual-cms'] );
	unset( $progress_theme_required_plugins['trx_updater'] );
	unset( $progress_theme_required_plugins['trx_popup'] );
}

// Add plugins list to the global storage
progress_storage_set( 'required_plugins', $progress_theme_required_plugins );
