<?php
/**
 * Skin Setup
 *
 * @package PROGRESS
 * @since PROGRESS 1.76.0
 */


//--------------------------------------------
// SKIN DEFAULTS
//--------------------------------------------

// Return theme's (skin's) default value for the specified parameter
if ( ! function_exists( 'progress_theme_defaults' ) ) {
	function progress_theme_defaults( $name = '', $value = '' ) {
		$defaults = array(
			'page_width'          => 1290,
			'page_boxed_extra'  => 60,
			'page_fullwide_max' => 1920,
			'page_fullwide_extra' => 60,
			'sidebar_width'       => 410,
			'sidebar_gap'       => 40,
			'grid_gap'          => 30,
			'rad'               => 0
		);
		if ( empty( $name ) ) {
			return $defaults;
		} else {
			if ( $value === '' && isset( $defaults[ $name ] ) ) {
				$value = $defaults[ $name ];
			}
			return $value;
		}
	}
}


// WOOCOMMERCE SETUP
//--------------------------------------------------

// Allow extended layouts for WooCommerce
if ( ! function_exists( 'progress_skin_woocommerce_allow_extensions' ) ) {
	add_filter( 'progress_filter_load_woocommerce_extensions', 'progress_skin_woocommerce_allow_extensions' );
	function progress_skin_woocommerce_allow_extensions( $allow ) {
		return false;
	}
}


// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)


//--------------------------------------------
// SKIN SETTINGS
//--------------------------------------------
if ( ! function_exists( 'progress_skin_setup' ) ) {
	add_action( 'after_setup_theme', 'progress_skin_setup', 1 );
	function progress_skin_setup() {

		$GLOBALS['PROGRESS_STORAGE'] = array_merge( $GLOBALS['PROGRESS_STORAGE'], array(

			// Key validator: market[env|loc]-vendor[axiom|ancora|themerex]
			'theme_pro_key'       => 'env-themerex',

			'theme_doc_url'       => '//doc.themerex.net/progress/',

			'theme_demofiles_url' => '//demofiles.themerex.net/progress/',
			
			'theme_rate_url'      => '//themeforest.net/downloads',

			'theme_custom_url'    => '//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themeinstall',

			'theme_support_url'   => '//themerex.net/support/',

			'theme_download_url'  => '//themeforest.net/user/themerex/portfolio',								// ThemeREX

			'theme_video_url'     => '//www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',						// ThemeREX

			'theme_privacy_url'   => '//themerex.net/privacy-policy/',											// ThemeREX

			'portfolio_url'       => '//themeforest.net/user/themerex/portfolio',								// ThemeREX

			// Comma separated slugs of theme-specific categories (for get relevant news in the dashboard widget)
			// (i.e. 'children,kindergarten')
			'theme_categories'    => '',
		) );
	}
}


// Add/remove/change Theme Settings
if ( ! function_exists( 'progress_skin_setup_settings' ) ) {
	add_action( 'after_setup_theme', 'progress_skin_setup_settings', 1 );
	function progress_skin_setup_settings() {
		// Example: enable (true) / disable (false) thumbs in the prev/next navigation
		progress_storage_set_array( 'settings', 'thumbs_in_navigation', false );
		progress_storage_set_array2( 'required_plugins', 'instagram-feed', 'install', false );
		progress_storage_set_array2( 'required_plugins', 'revslider', 'install', true );
	}
}



//--------------------------------------------
// SKIN FONTS
//--------------------------------------------
if ( ! function_exists( 'progress_skin_setup_fonts' ) ) {
	add_action( 'after_setup_theme', 'progress_skin_setup_fonts', 1 );
	function progress_skin_setup_fonts() {
		// Fonts to load when theme start
		// It can be:
		// - Google fonts (specify name, family and styles)
		// - Adobe fonts (specify name, family and link URL)
		// - uploaded fonts (specify name, family), placed in the folder css/font-face/font-name inside the skin folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		progress_storage_set(
			'load_fonts', array(
				array(
					'name'   => 'transat-text',
					'family' => 'sans-serif',
					'link'   => 'https://use.typekit.net/oqi0gpz.css',
				),
				// Google font
				array(
					'name'   => 'DM Sans',
					'family' => 'sans-serif',
					'link'   => '',
					'styles' => 'ital,wght@0,400;0,500;0,700;1,400;1,500;1,700',     // Parameter 'style' used only for the Google fonts
				),
			)
		);

		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		progress_storage_set( 'load_fonts_subset', 'latin,latin-ext' );

		// Settings of the main tags.
		// Default value of 'font-family' may be specified as reference to the array $load_fonts (see above)
		// or as comma-separated string.
		// In the second case (if 'font-family' is specified manually as comma-separated string):
		//    1) Font name with spaces in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		//    2) If font-family inherit a value from the 'Main text' - specify 'inherit' as a value
		// example:
		// Correct:   'font-family' => progress_get_load_fonts_family_string( $load_fonts[0] )
		// Correct:   'font-family' => 'Roboto,sans-serif'
		// Correct:   'font-family' => '"PT Serif",sans-serif'
		// Incorrect: 'font-family' => 'Roboto, sans-serif'
		// Incorrect: 'font-family' => 'PT Serif,sans-serif'

		$font_description = esc_html__( 'Please use only the following units: "rem" or "em".', 'progress' )
							. ( is_customize_preview() ? '<br>' . esc_html__( 'Press "Reload preview area" button at the top of this panel after the all font parameters are changed.', 'progress' ) : '' );

		progress_storage_set(
			'theme_fonts', array(
				'p'       => array(
					'title'           => esc_html__( 'Main text', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'main text', 'progress' ) ),
					'font-family'     => '"DM Sans",sans-serif',
					'font-size'       => '1rem',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.62em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0em',
					'margin-bottom'   => '1.57em',
				),
				'post'    => array(
					'title'           => esc_html__( 'Article text', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'article text', 'progress' ) ),
					'font-family'     => 'inherit',		// Example: '"PR Serif",serif',
					'font-size'       => '',			// Example: '1.286rem',
					'font-weight'     => 'inherit',		// Example: '400',
					'font-style'      => 'inherit',		// Example: 'normal',
					'line-height'     => '',			// Example: '1.75em',
					'text-decoration' => 'inherit',		// Example: 'none',
					'text-transform'  => 'inherit',		// Example: 'none',
					'letter-spacing'  => '',			// Example: '',
					'margin-top'      => '',			// Example: '0em',
					'margin-bottom'   => '',			// Example: '1.4em',
				),
				'h1'      => array(
					'title'           => esc_html__( 'Heading 1', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H1', 'progress' ) ),
					'font-family'     => 'transat-text,sans-serif',
					'font-size'       => '3.167em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-1.2px',
					'margin-top'      => '1.12em',
					'margin-bottom'   => '0.38em',
				),
				'h2'      => array(
					'title'           => esc_html__( 'Heading 2', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H2', 'progress' ) ),
					'font-family'     => 'transat-text,sans-serif',
					'font-size'       => '2.611em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.021em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.9px',
					'margin-top'      => '0.79em',
					'margin-bottom'   => '0.45em',
				),
				'h3'      => array(
					'title'           => esc_html__( 'Heading 3', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H3', 'progress' ) ),
					'font-family'     => 'transat-text,sans-serif',
					'font-size'       => '1.944em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.086em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '-0.5px',
					'margin-top'      => '0.9em',
					'margin-bottom'   => '0.6em',
				),
				'h4'      => array(
					'title'           => esc_html__( 'Heading 4', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H4', 'progress' ) ),
					'font-family'     => 'transat-text,sans-serif',
					'font-size'       => '1.556em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.214em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1em',
					'margin-bottom'   => '0.63em',
				),
				'h5'      => array(
					'title'           => esc_html__( 'Heading 5', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H5', 'progress' ) ),
					'font-family'     => 'transat-text,sans-serif',
					'font-size'       => '1.333em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.208em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.3em',
					'margin-bottom'   => '0.72em',
				),
				'h6'      => array(
					'title'           => esc_html__( 'Heading 6', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'tag H6', 'progress' ) ),
					'font-family'     => 'transat-text,sans-serif',
					'font-size'       => '1.056em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.556em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '1.5em',
					'margin-bottom'   => '0.7em',
				),
				'logo'    => array(
					'title'           => esc_html__( 'Logo text', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'text of the logo', 'progress' ) ),
					'font-family'     => 'transat-text,sans-serif',
					'font-size'       => '1.8em',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '1.25em',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '0px',
				),
				'button'  => array(
					'title'           => esc_html__( 'Buttons', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'buttons', 'progress' ) ),
					'font-family'     => 'transat-text,sans-serif',
					'font-size'       => '14px',
					'font-weight'     => '700',
					'font-style'      => 'normal',
					'line-height'     => '20px',
					'text-decoration' => 'none',
					'text-transform'  => 'uppercase',
					'letter-spacing'  => '1.4px',
				),
				'input'   => array(
					'title'           => esc_html__( 'Input fields', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'input fields, dropdowns and textareas', 'progress' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '16px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',     // Attention! Firefox don't allow line-height less then 1.5em in the select
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'info'    => array(
					'title'           => esc_html__( 'Post meta', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'post meta (author, categories, publish date, counters, share, etc.)', 'progress' ) ),
					'font-family'     => 'inherit',
					'font-size'       => '14px',  // Old value '13px' don't allow using 'font zoom' in the custom blog items
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
					'margin-top'      => '0.4em',
					'margin-bottom'   => '',
				),
				'menu'    => array(
					'title'           => esc_html__( 'Main menu', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'main menu items', 'progress' ) ),
					'font-family'     => 'transat-text,sans-serif',
					'font-size'       => '17px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'submenu' => array(
					'title'           => esc_html__( 'Dropdown menu', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'dropdown menu items', 'progress' ) ),
					'font-family'     => '"DM Sans",sans-serif',
					'font-size'       => '15px',
					'font-weight'     => '400',
					'font-style'      => 'normal',
					'line-height'     => '1.5em',
					'text-decoration' => 'none',
					'text-transform'  => 'none',
					'letter-spacing'  => '0px',
				),
				'other' => array(
					'title'           => esc_html__( 'Other', 'progress' ),
					'description'     => sprintf( $font_description, esc_html__( 'specific elements', 'progress' ) ),
					'font-family'     => '"DM Sans",sans-serif',
				),
			)
		);

		// Font presets
		progress_storage_set(
			'font_presets', array(
				'karla' => array(
					'title'  => esc_html__( 'Karla', 'progress' ),
					'load_fonts' => array(
						// Google font
						array(
							'name'   => 'Dancing Script',
							'family' => 'fantasy',
							'link'   => '',
							'styles' => '300,400,700',
						),
						// Google font
						array(
							'name'   => 'Sansita Swashed',
							'family' => 'fantasy',
							'link'   => '',
							'styles' => '300,400,700',
						),
					),
					'theme_fonts' => array(
						'p'       => array(
							'font-family'     => '"Dancing Script",fantasy',
							'font-size'       => '1.25rem',
						),
						'post'    => array(
							'font-family'     => '',
						),
						'h1'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
							'font-size'       => '4em',
						),
						'h2'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'h3'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'h4'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'h5'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'h6'      => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'logo'    => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'button'  => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'input'   => array(
							'font-family'     => 'inherit',
						),
						'info'    => array(
							'font-family'     => 'inherit',
						),
						'menu'    => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
						'submenu' => array(
							'font-family'     => '"Sansita Swashed",fantasy',
						),
					),
				),
				'roboto' => array(
					'title'  => esc_html__( 'Roboto', 'progress' ),
					'load_fonts' => array(
						// Google font
						array(
							'name'   => 'Noto Sans JP',
							'family' => 'serif',
							'link'   => '',
							'styles' => '300,300italic,400,400italic,700,700italic',
						),
						// Google font
						array(
							'name'   => 'Merriweather',
							'family' => 'sans-serif',
							'link'   => '',
							'styles' => '300,300italic,400,400italic,700,700italic',
						),
					),
					'theme_fonts' => array(
						'p'       => array(
							'font-family'     => '"Noto Sans JP",serif',
						),
						'post'    => array(
							'font-family'     => '',
						),
						'h1'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h2'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h3'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h4'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h5'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'h6'      => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'logo'    => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'button'  => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'input'   => array(
							'font-family'     => 'inherit',
						),
						'info'    => array(
							'font-family'     => 'inherit',
						),
						'menu'    => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
						'submenu' => array(
							'font-family'     => 'Merriweather,sans-serif',
						),
					),
				),
				'garamond' => array(
					'title'  => esc_html__( 'Garamond', 'progress' ),
					'load_fonts' => array(
						// Adobe font
						array(
							'name'   => 'Europe',
							'family' => 'sans-serif',
							'link'   => 'https://use.typekit.net/qmj1tmx.css',
							'styles' => '',
						),
						// Adobe font
						array(
							'name'   => 'Sofia Pro',
							'family' => 'sans-serif',
							'link'   => 'https://use.typekit.net/qmj1tmx.css',
							'styles' => '',
						),
					),
					'theme_fonts' => array(
						'p'       => array(
							'font-family'     => '"Sofia Pro",sans-serif',
						),
						'post'    => array(
							'font-family'     => '',
						),
						'h1'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h2'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h3'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h4'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h5'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'h6'      => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'logo'    => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'button'  => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'input'   => array(
							'font-family'     => 'inherit',
						),
						'info'    => array(
							'font-family'     => 'inherit',
						),
						'menu'    => array(
							'font-family'     => 'Europe,sans-serif',
						),
						'submenu' => array(
							'font-family'     => 'Europe,sans-serif',
						),
					),
				),
			)
		);
	}
}


//--------------------------------------------
// COLOR SCHEMES
//--------------------------------------------
if ( ! function_exists( 'progress_skin_setup_schemes' ) ) {
	add_action( 'after_setup_theme', 'progress_skin_setup_schemes', 1 );
	function progress_skin_setup_schemes() {

		// Theme colors for customizer
		// Attention! Inner scheme must be last in the array below
		progress_storage_set(
			'scheme_color_groups', array(
				'main'    => array(
					'title'       => esc_html__( 'Main', 'progress' ),
					'description' => esc_html__( 'Colors of the main content area', 'progress' ),
				),
				'alter'   => array(
					'title'       => esc_html__( 'Alter', 'progress' ),
					'description' => esc_html__( 'Colors of the alternative blocks (sidebars, etc.)', 'progress' ),
				),
				'extra'   => array(
					'title'       => esc_html__( 'Extra', 'progress' ),
					'description' => esc_html__( 'Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'progress' ),
				),
				'inverse' => array(
					'title'       => esc_html__( 'Inverse', 'progress' ),
					'description' => esc_html__( 'Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'progress' ),
				),
				'input'   => array(
					'title'       => esc_html__( 'Input', 'progress' ),
					'description' => esc_html__( 'Colors of the form fields (text field, textarea, select, etc.)', 'progress' ),
				),
			)
		);

		progress_storage_set(
			'scheme_color_names', array(
				'bg_color'    => array(
					'title'       => esc_html__( 'Background color', 'progress' ),
					'description' => esc_html__( 'Background color of this block in the normal state', 'progress' ),
				),
				'bg_hover'    => array(
					'title'       => esc_html__( 'Background hover', 'progress' ),
					'description' => esc_html__( 'Background color of this block in the hovered state', 'progress' ),
				),
				'bd_color'    => array(
					'title'       => esc_html__( 'Border color', 'progress' ),
					'description' => esc_html__( 'Border color of this block in the normal state', 'progress' ),
				),
				'bd_hover'    => array(
					'title'       => esc_html__( 'Border hover', 'progress' ),
					'description' => esc_html__( 'Border color of this block in the hovered state', 'progress' ),
				),
				'text'        => array(
					'title'       => esc_html__( 'Text', 'progress' ),
					'description' => esc_html__( 'Color of the text inside this block', 'progress' ),
				),
				'text_dark'   => array(
					'title'       => esc_html__( 'Text dark', 'progress' ),
					'description' => esc_html__( 'Color of the dark text (bold, header, etc.) inside this block', 'progress' ),
				),
				'text_light'  => array(
					'title'       => esc_html__( 'Text light', 'progress' ),
					'description' => esc_html__( 'Color of the light text (post meta, etc.) inside this block', 'progress' ),
				),
				'text_link'   => array(
					'title'       => esc_html__( 'Link', 'progress' ),
					'description' => esc_html__( 'Color of the links inside this block', 'progress' ),
				),
				'text_hover'  => array(
					'title'       => esc_html__( 'Link hover', 'progress' ),
					'description' => esc_html__( 'Color of the hovered state of links inside this block', 'progress' ),
				),
				'text_link2'  => array(
					'title'       => esc_html__( 'Accent 2', 'progress' ),
					'description' => esc_html__( 'Color of the accented texts (areas) inside this block', 'progress' ),
				),
				'text_hover2' => array(
					'title'       => esc_html__( 'Accent 2 hover', 'progress' ),
					'description' => esc_html__( 'Color of the hovered state of accented texts (areas) inside this block', 'progress' ),
				),
				'text_link3'  => array(
					'title'       => esc_html__( 'Accent 3', 'progress' ),
					'description' => esc_html__( 'Color of the other accented texts (buttons) inside this block', 'progress' ),
				),
				'text_hover3' => array(
					'title'       => esc_html__( 'Accent 3 hover', 'progress' ),
					'description' => esc_html__( 'Color of the hovered state of other accented texts (buttons) inside this block', 'progress' ),
				),
			)
		);

		// Default values for each color scheme
		$schemes = array(

			// Color scheme: 'default'
			'default' => array(
				'title'    => esc_html__( 'Default', 'progress' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F6F6F6',
					'bd_color'         => '#E3E3E3',

					// Text and links colors
					'text'             => '#858585',
					'text_light'       => '#A5A6AA',
					'text_dark'        => '#1A1B1C',
					'text_link'        => '#F6483D',
					'text_hover'       => '#E7362A',
					'text_link2'       => '#324FB3',
					'text_hover2'      => '#213EA1',
					'text_link3'       => '#FFA800',
					'text_hover3'      => '#F09E00',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF',
					'alter_bg_hover'   => '#EAECF9',
					'alter_bd_color'   => '#E3E3E3',
					'alter_bd_hover'   => '#C3C3C3',
					'alter_text'       => '#858585',
					'alter_light'      => '#A5A6AA',
					'alter_dark'       => '#1A1B1C',
					'alter_link'       => '#F6483D',
					'alter_hover'      => '#E7362A',
					'alter_link2'      => '#324FB3',
					'alter_hover2'     => '#213EA1',
					'alter_link3'      => '#FFA800',
					'alter_hover3'     => '#F09E00',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1B1B1B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#2C2C2C',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#DADADA',
					'extra_light'      => '#A39E9E',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#F6483D',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E3E3E3',
					'input_bd_hover'   => '#C3C3C3',
					'input_text'       => '#A5A6AA',
					'input_light'      => '#A5A6AA',
					'input_dark'       => '#1A1B1C',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#858585',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#1A1B1C',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#FFFEFE',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'dark'
			'dark'    => array(
				'title'    => esc_html__( 'Dark', 'progress' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#191818',
					'bd_color'         => '#2C2C2C',

					// Text and links colors
					'text'             => '#DADADA',
					'text_light'       => '#A39E9E',
					'text_dark'        => '#FFFEFE',
					'text_link'        => '#F6483D',
					'text_hover'       => '#E7362A',
					'text_link2'       => '#324FB3',
					'text_hover2'      => '#213EA1',
					'text_link3'       => '#FFA800',
					'text_hover3'      => '#F09E00',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#0E0E0E',
					'alter_bg_hover'   => '#151515',
					'alter_bd_color'   => '#2C2C2C',
					'alter_bd_hover'   => '#2C2C2C',
					'alter_text'       => '#DADADA',
					'alter_light'      => '#A39E9E',
					'alter_dark'       => '#FFFEFE',
					'alter_link'       => '#F6483D',
					'alter_hover'      => '#E7362A',
					'alter_link2'      => '#324FB3',
					'alter_hover2'     => '#213EA1',
					'alter_link3'      => '#FFA800',
					'alter_hover3'     => '#F09E00',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1B1B1B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#2C2C2C',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#DADADA',
					'extra_light'      => '#A39E9E',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#F6483D',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#2C2C2C',
					'input_bd_hover'   => '#393939',
					'input_text'       => '#DADADA',
					'input_light'      => '#DADADA',
					'input_dark'       => '#FFFEFE',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FFFEFE',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#1A1B1C',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#1A1B1C',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'light'
			'light' => array(
				'title'    => esc_html__( 'Light', 'progress' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFFF',
					'bd_color'         => '#E3E3E3',

					// Text and links colors
					'text'             => '#858585',
					'text_light'       => '#A5A6AA',
					'text_dark'        => '#1A1B1C',
					'text_link'        => '#F6483D',
					'text_hover'       => '#E7362A',
					'text_link2'       => '#324FB3',
					'text_hover2'      => '#213EA1',
					'text_link3'       => '#FFA800',
					'text_hover3'      => '#F09E00',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F6F6F6',
					'alter_bg_hover'   => '#EAECF9',
					'alter_bd_color'   => '#E3E3E3',
					'alter_bd_hover'   => '#C3C3C3',
					'alter_text'       => '#858585',
					'alter_light'      => '#A5A6AA',
					'alter_dark'       => '#1A1B1C',
					'alter_link'       => '#F6483D',
					'alter_hover'      => '#E7362A',
					'alter_link2'      => '#324FB3',
					'alter_hover2'     => '#213EA1',
					'alter_link3'      => '#FFA800',
					'alter_hover3'     => '#F09E00',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#1B1B1B',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#2C2C2C',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#DADADA',
					'extra_light'      => '#A39E9E',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#F6483D',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#E3E3E3',
					'input_bd_hover'   => '#C3C3C3',
					'input_text'       => '#A5A6AA',
					'input_light'      => '#A5A6AA',
					'input_dark'       => '#1A1B1C',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#858585',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#1A1B1C',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#FFFEFE',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'purple_default'
			'purple_default' => array(
				'title'    => esc_html__( 'Purple Default', 'progress' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#F5F6FF',
					'bd_color'         => '#DADCE9',

					// Text and links colors
					'text'             => '#858585',
					'text_light'       => '#A5A6AA',
					'text_dark'        => '#171717',
					'text_link'        => '#F97D36',
					'text_hover'       => '#F0722A',
					'text_link2'       => '#616CD0',
					'text_hover2'      => '#4B57C8',
					'text_link3'       => '#AC55D5',
					'text_hover3'      => '#A245CD',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#FFFFFF',
					'alter_bg_hover'   => '#EAECF9',
					'alter_bd_color'   => '#DADCE9',
					'alter_bd_hover'   => '#CDCFE1',
					'alter_text'       => '#858585',
					'alter_light'      => '#A5A6AA',
					'alter_dark'       => '#171717',
					'alter_link'       => '#F97D36',
					'alter_hover'      => '#F0722A',
					'alter_link2'      => '#616CD0',
					'alter_hover2'     => '#4B57C8',
					'alter_link3'      => '#AC55D5',
					'alter_hover3'     => '#A245CD',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#171717',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#363940',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#DADADA',
					'extra_light'      => '#A39E9E',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#F97D36',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DADCE9',
					'input_bd_hover'   => '#CDCFE1',
					'input_text'       => '#A5A6AA',
					'input_light'      => '#A5A6AA',
					'input_dark'       => '#171717',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#858585',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#171717',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#FFFEFE',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'purple_dark'
			'purple_dark'    => array(
				'title'    => esc_html__( 'Purple Dark', 'progress' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#131314',
					'bd_color'         => '#363940',

					// Text and links colors
					'text'             => '#DADADA',
					'text_light'       => '#A39E9E',
					'text_dark'        => '#FFFEFE',
					'text_link'        => '#F97D36',
					'text_hover'       => '#F0722A',
					'text_link2'       => '#616CD0',
					'text_hover2'      => '#4B57C8',
					'text_link3'       => '#AC55D5',
					'text_hover3'      => '#A245CD',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#191C25',
					'alter_bg_hover'   => '#232631',
					'alter_bd_color'   => '#363940',
					'alter_bd_hover'   => '#363940',
					'alter_text'       => '#DADADA',
					'alter_light'      => '#A39E9E',
					'alter_dark'       => '#FFFEFE',
					'alter_link'       => '#F97D36',
					'alter_hover'      => '#F0722A',
					'alter_link2'      => '#616CD0',
					'alter_hover2'     => '#4B57C8',
					'alter_link3'      => '#AC55D5',
					'alter_hover3'     => '#A245CD',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#171717',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#363940',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#DADADA',
					'extra_light'      => '#A39E9E',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#F97D36',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => '#transparent',
					'input_bg_hover'   => '#transparent',
					'input_bd_color'   => '#363940',
					'input_bd_hover'   => '#474950',
					'input_text'       => '#DADADA',
					'input_light'      => '#DADADA',
					'input_dark'       => '#FFFEFE',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#FFFEFE',
					'inverse_bd_hover' => '#2E2D2D',
					'inverse_text'     => '#F9F9F9',
					'inverse_light'    => '#6f6f6f',
					'inverse_dark'     => '#171717',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#171717',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),

			// Color scheme: 'purple_light'
			'purple_light' => array(
				'title'    => esc_html__( 'Purple Light', 'progress' ),
				'internal' => true,
				'colors'   => array(

					// Whole block border and background
					'bg_color'         => '#FFFFFF',
					'bd_color'         => '#DADCE9',

					// Text and links colors
					'text'             => '#858585',
					'text_light'       => '#A5A6AA',
					'text_dark'        => '#171717',
					'text_link'        => '#F97D36',
					'text_hover'       => '#F0722A',
					'text_link2'       => '#616CD0',
					'text_hover2'      => '#4B57C8',
					'text_link3'       => '#AC55D5',
					'text_hover3'      => '#A245CD',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'   => '#F5F6FF',
					'alter_bg_hover'   => '#EAECF9',
					'alter_bd_color'   => '#DADCE9',
					'alter_bd_hover'   => '#CDCFE1',
					'alter_text'       => '#858585',
					'alter_light'      => '#A5A6AA',
					'alter_dark'       => '#171717',
					'alter_link'       => '#F97D36',
					'alter_hover'      => '#F0722A',
					'alter_link2'      => '#616CD0',
					'alter_hover2'     => '#4B57C8',
					'alter_link3'      => '#AC55D5',
					'alter_hover3'     => '#A245CD',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'   => '#171717',
					'extra_bg_hover'   => '#3f3d47',
					'extra_bd_color'   => '#363940',
					'extra_bd_hover'   => '#575757',
					'extra_text'       => '#DADADA',
					'extra_light'      => '#A39E9E',
					'extra_dark'       => '#FFFEFE',
					'extra_link'       => '#F97D36',
					'extra_hover'      => '#FFFEFE',
					'extra_link2'      => '#80d572',
					'extra_hover2'     => '#8be77c',
					'extra_link3'      => '#ddb837',
					'extra_hover3'     => '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'   => 'transparent',
					'input_bg_hover'   => 'transparent',
					'input_bd_color'   => '#DADCE9',
					'input_bd_hover'   => '#CDCFE1',
					'input_text'       => '#A5A6AA',
					'input_light'      => '#A5A6AA',
					'input_dark'       => '#171717',

					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color' => '#858585',
					'inverse_bd_hover' => '#FFFFFF',
					'inverse_text'     => '#1d1d1d',
					'inverse_light'    => '#333333',
					'inverse_dark'     => '#171717',
					'inverse_link'     => '#FFFEFE',
					'inverse_hover'    => '#FFFEFE',

					// Additional (skin-specific) colors.
					// Attention! Set of colors must be equal in all color schemes.
					//---> For example:
					//---> 'new_color1'         => '#rrggbb',
					//---> 'alter_new_color1'   => '#rrggbb',
					//---> 'inverse_new_color1' => '#rrggbb',
				),
			),			
		);
		progress_storage_set( 'schemes', $schemes );
		progress_storage_set( 'schemes_original', $schemes );

		// Add names of additional colors
		//---> For example:
		//---> progress_storage_set_array( 'scheme_color_names', 'new_color1', array(
		//---> 	'title'       => __( 'New color 1', 'progress' ),
		//---> 	'description' => __( 'Description of the new color 1', 'progress' ),
		//---> ) );


		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		progress_storage_set(
			'scheme_colors_add', array(
				'bg_color_0'        => array(
					'color' => 'bg_color',
					'alpha' => 0,
				),
				'bg_color_02'       => array(
					'color' => 'bg_color',
					'alpha' => 0.2,
				),
				'bg_color_07'       => array(
					'color' => 'bg_color',
					'alpha' => 0.7,
				),
				'bg_color_08'       => array(
					'color' => 'bg_color',
					'alpha' => 0.8,
				),
				'bg_color_09'       => array(
					'color' => 'bg_color',
					'alpha' => 0.9,
				),
				'alter_bg_color_07' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.7,
				),
				'alter_bg_color_08' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.8,
				),
				'alter_bg_color_04' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.4,
				),
				'alter_bg_color_00' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0,
				),
				'alter_bg_color_02' => array(
					'color' => 'alter_bg_color',
					'alpha' => 0.2,
				),
				'alter_bd_color_02' => array(
					'color' => 'alter_bd_color',
					'alpha' => 0.2,
				),
				'alter_dark_015'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.15,
				),
				'alter_dark_02'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.2,
				),
				'alter_dark_05'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.5,
				),
				'alter_dark_08'     => array(
					'color' => 'alter_dark',
					'alpha' => 0.8,
				),
				'alter_link_02'     => array(
					'color' => 'alter_link',
					'alpha' => 0.2,
				),
				'alter_link_07'     => array(
					'color' => 'alter_link',
					'alpha' => 0.7,
				),
				'extra_bg_color_05' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.5,
				),
				'extra_bg_color_07' => array(
					'color' => 'extra_bg_color',
					'alpha' => 0.7,
				),
				'extra_link_02'     => array(
					'color' => 'extra_link',
					'alpha' => 0.2,
				),
				'extra_text_07'      => array(
					'color' => 'extra_text',
					'alpha' => 0.7,
				),				
				'extra_link_07'     => array(
					'color' => 'extra_link',
					'alpha' => 0.7,
				),
				'text_dark_003'      => array(
					'color' => 'text_dark',
					'alpha' => 0.03,
				),
				'text_dark_005'      => array(
					'color' => 'text_dark',
					'alpha' => 0.05,
				),
				'text_dark_008'      => array(
					'color' => 'text_dark',
					'alpha' => 0.08,
				),
				'text_dark_015'      => array(
					'color' => 'text_dark',
					'alpha' => 0.15,
				),
				'text_dark_02'      => array(
					'color' => 'text_dark',
					'alpha' => 0.2,
				),
				'text_dark_03'      => array(
					'color' => 'text_dark',
					'alpha' => 0.3,
				),
				'text_dark_05'      => array(
					'color' => 'text_dark',
					'alpha' => 0.5,
				),
				'text_dark_07'      => array(
					'color' => 'text_dark',
					'alpha' => 0.7,
				),
				'text_dark_08'      => array(
					'color' => 'text_dark',
					'alpha' => 0.8,
				),
				'text_link_007'      => array(
					'color' => 'text_link',
					'alpha' => 0.07,
				),
				'text_link_02'      => array(
					'color' => 'text_link',
					'alpha' => 0.2,
				),
				'text_link_03'      => array(
					'color' => 'text_link',
					'alpha' => 0.3,
				),
				'text_link_04'      => array(
					'color' => 'text_link',
					'alpha' => 0.4,
				),
				'text_link_07'      => array(
					'color' => 'text_link',
					'alpha' => 0.7,
				),
				'text_link2_08'      => array(
					'color' => 'text_link2',
					'alpha' => 0.8,
				),
				'text_link2_007'      => array(
					'color' => 'text_link2',
					'alpha' => 0.07,
				),
				'text_link2_02'      => array(
					'color' => 'text_link2',
					'alpha' => 0.2,
				),
				'text_link2_03'      => array(
					'color' => 'text_link2',
					'alpha' => 0.3,
				),
				'text_link2_05'      => array(
					'color' => 'text_link2',
					'alpha' => 0.5,
				),
				'text_link3_007'      => array(
					'color' => 'text_link3',
					'alpha' => 0.07,
				),
				'text_link3_02'      => array(
					'color' => 'text_link3',
					'alpha' => 0.2,
				),
				'text_link3_03'      => array(
					'color' => 'text_link3',
					'alpha' => 0.3,
				),
				'inverse_text_03'      => array(
					'color' => 'inverse_text',
					'alpha' => 0.3,
				),
				'inverse_link_08'      => array(
					'color' => 'inverse_link',
					'alpha' => 0.8,
				),
				'inverse_hover_08'      => array(
					'color' => 'inverse_hover',
					'alpha' => 0.8,
				),
				'text_dark_blend'   => array(
					'color'      => 'text_dark',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'text_link_blend'   => array(
					'color'      => 'text_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
				'alter_link_blend'  => array(
					'color'      => 'alter_link',
					'hue'        => 2,
					'saturation' => -5,
					'brightness' => 5,
				),
			)
		);

		// Simple scheme editor: lists the colors to edit in the "Simple" mode.
		// For each color you can set the array of 'slave' colors and brightness factors that are used to generate new values,
		// when 'main' color is changed
		// Leave 'slave' arrays empty if your scheme does not have a color dependency
		progress_storage_set(
			'schemes_simple', array(
				'text_link'        => array(),
				'text_hover'       => array(),
				'text_link2'       => array(),
				'text_hover2'      => array(),
				'text_link3'       => array(),
				'text_hover3'      => array(),
				'alter_link'       => array(),
				'alter_hover'      => array(),
				'alter_link2'      => array(),
				'alter_hover2'     => array(),
				'alter_link3'      => array(),
				'alter_hover3'     => array(),
				'extra_link'       => array(),
				'extra_hover'      => array(),
				'extra_link2'      => array(),
				'extra_hover2'     => array(),
				'extra_link3'      => array(),
				'extra_hover3'     => array(),
			)
		);

		// Parameters to set order of schemes in the css
		progress_storage_set(
			'schemes_sorted', array(
				'color_scheme',
				'header_scheme',
				'menu_scheme',
				'sidebar_scheme',
				'footer_scheme',
			)
		);

		// Color presets
		progress_storage_set(
			'color_presets', array(
				'autumn' => array(
					'title'  => esc_html__( 'Autumn', 'progress' ),
					'colors' => array(
						'default' => array(
							'text_link'  => '#d83938',
							'text_hover' => '#f2b232',
						),
						'dark' => array(
							'text_link'  => '#d83938',
							'text_hover' => '#f2b232',
						)
					)
				),
				'green' => array(
					'title'  => esc_html__( 'Natural Green', 'progress' ),
					'colors' => array(
						'default' => array(
							'text_link'  => '#75ac78',
							'text_hover' => '#378e6d',
						),
						'dark' => array(
							'text_link'  => '#75ac78',
							'text_hover' => '#378e6d',
						)
					)
				),
			)
		);
	}
}


//Enqueue skin-specific scripts
if ( ! function_exists( 'progress_skin_upgrade_style' ) ) {
	add_action( 'wp_enqueue_scripts', 'progress_skin_upgrade_style', 2060 );
	function progress_skin_upgrade_style() {
		$progress_url = progress_get_file_url( progress_skins_get_current_skin_dir() . 'skin-upgrade-style.css' );	
		if ( '' != $progress_url ) {
			wp_enqueue_style( 'progress-skin-upgrade-style' . esc_attr( progress_skins_get_current_skin_name() ), $progress_url, array(), null );
		}
	}
}

// Activation methods
if ( ! function_exists( 'progress_skin_filter_activation_methods2' ) ) {
	add_filter( 'trx_addons_filter_activation_methods', 'progress_skin_filter_activation_methods2', 11, 1 );
	function progress_skin_filter_activation_methods2( $args ) {
		$args['elements_key'] = true;
		return $args;
	}
}