<?php
/**
 * The template to display Admin notices
 *
 * @package PROGRESS
 * @since PROGRESS 1.0.1
 */

$progress_theme_slug = get_option( 'template' );
$progress_theme_obj  = wp_get_theme( $progress_theme_slug );
?>
<div class="progress_admin_notice progress_welcome_notice notice notice-info is-dismissible" data-notice="admin">
	<?php
	// Theme image
	$progress_theme_img = progress_get_file_url( 'screenshot.jpg' );
	if ( '' != $progress_theme_img ) {
		?>
		<div class="progress_notice_image"><img src="<?php echo esc_url( $progress_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'progress' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="progress_notice_title">
		<?php
		echo esc_html(
			sprintf(
				// Translators: Add theme name and version to the 'Welcome' message
				__( 'Welcome to %1$s v.%2$s', 'progress' ),
				$progress_theme_obj->get( 'Name' ) . ( PROGRESS_THEME_FREE ? ' ' . __( 'Free', 'progress' ) : '' ),
				$progress_theme_obj->get( 'Version' )
			)
		);
		?>
	</h3>
	<?php

	// Description
	?>
	<div class="progress_notice_text">
		<p class="progress_notice_text_description">
			<?php
			echo str_replace( '. ', '.<br>', wp_kses_data( $progress_theme_obj->description ) );
			?>
		</p>
		<p class="progress_notice_text_info">
			<?php
			echo wp_kses_data( __( 'Attention! Plugin "ThemeREX Addons" is required! Please, install and activate it!', 'progress' ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="progress_notice_buttons">
		<?php
		// Link to the page 'About Theme'
		?>
		<a href="<?php echo esc_url( admin_url() . 'themes.php?page=progress_about' ); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> 
			<?php
			echo esc_html__( 'Install plugin "ThemeREX Addons"', 'progress' );
			?>
		</a>
	</div>
</div>
