<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

$progress_template_args = get_query_var( 'progress_template_args' );

if ( is_array( $progress_template_args ) ) {
	$progress_columns    = empty( $progress_template_args['columns'] ) ? 2 : max( 1, $progress_template_args['columns'] );
	$progress_blog_style = array( $progress_template_args['type'], $progress_columns );
    $progress_columns_class = progress_get_column_class( 1, $progress_columns, ! empty( $progress_template_args['columns_tablet']) ? $progress_template_args['columns_tablet'] : '', ! empty($progress_template_args['columns_mobile']) ? $progress_template_args['columns_mobile'] : '' );
} else {
	$progress_template_args = array();
	$progress_blog_style = explode( '_', progress_get_theme_option( 'blog_style' ) );
	$progress_columns    = empty( $progress_blog_style[1] ) ? 2 : max( 1, $progress_blog_style[1] );
    $progress_columns_class = progress_get_column_class( 1, $progress_columns );
}
$progress_expanded   = ! progress_sidebar_present() && progress_get_theme_option( 'expand_content' ) == 'expand';

$progress_post_format = get_post_format();
$progress_post_format = empty( $progress_post_format ) ? 'standard' : str_replace( 'post-format-', '', $progress_post_format );

?><div class="<?php
	if ( ! empty( $progress_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( progress_is_blog_style_use_masonry( $progress_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $progress_columns ) : esc_attr( $progress_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $progress_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $progress_columns )
				. ' post_layout_' . esc_attr( $progress_blog_style[0] )
				. ' post_layout_' . esc_attr( $progress_blog_style[0] ) . '_' . esc_attr( $progress_columns )
	);
	progress_add_blog_animation( $progress_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$progress_hover      = ! empty( $progress_template_args['hover'] ) && ! progress_is_inherit( $progress_template_args['hover'] )
							? $progress_template_args['hover']
							: progress_get_theme_option( 'image_hover' );

	$progress_components = ! empty( $progress_template_args['meta_parts'] )
							? ( is_array( $progress_template_args['meta_parts'] )
								? $progress_template_args['meta_parts']
								: explode( ',', $progress_template_args['meta_parts'] )
								)
							: progress_array_get_keys_by_value( progress_get_theme_option( 'meta_parts' ) );

	progress_show_post_featured( apply_filters( 'progress_filter_args_featured',
		array(
			'thumb_size' => ! empty( $progress_template_args['thumb_size'] )
				? $progress_template_args['thumb_size']
				: progress_get_thumb_size(
					'classic' == $progress_blog_style[0]
						? ( strpos( progress_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $progress_columns > 2 ? 'big' : 'huge' )
								: ( $progress_columns > 2
									? ( $progress_expanded ? 'square' : 'square' )
									: ($progress_columns > 1 ? 'square' : ( $progress_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( progress_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $progress_columns > 2 ? 'masonry-big' : 'full' )
								: ($progress_columns === 1 ? ( $progress_expanded ? 'huge' : 'big' ) : ( $progress_columns <= 2 && $progress_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $progress_hover,
			'meta_parts' => $progress_components,
			'no_links'   => ! empty( $progress_template_args['no_links'] ),
        ),
        'content-classic',
        $progress_template_args
    ) );

	// Title and post meta
	$progress_show_title = get_the_title() != '';
	$progress_show_meta  = count( $progress_components ) > 0 && ! in_array( $progress_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $progress_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'progress_filter_show_blog_meta', $progress_show_meta, $progress_components, 'classic' ) ) {
				if ( count( $progress_components ) > 0 ) {
					do_action( 'progress_action_before_post_meta' );
					progress_show_post_meta(
						apply_filters(
							'progress_filter_post_meta_args', array(
							'components' => join( ',', $progress_components ),
							'seo'        => false,
							'echo'       => true,
						), $progress_blog_style[0], $progress_columns
						)
					);
					do_action( 'progress_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'progress_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'progress_action_before_post_title' );
				if ( empty( $progress_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'progress_action_after_post_title' );
			}

			if( !in_array( $progress_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'progress_filter_show_blog_readmore', ! $progress_show_title || ! empty( $progress_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $progress_template_args['no_links'] ) ) {
						do_action( 'progress_action_before_post_readmore' );
						progress_show_post_more_link( $progress_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'progress_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $progress_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('progress_filter_show_blog_excerpt', empty($progress_template_args['hide_excerpt']) && progress_get_theme_option('excerpt_length') > 0, 'classic')) {
			progress_show_post_content($progress_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $progress_template_args['more_button'] )) {
			if ( empty( $progress_template_args['no_links'] ) ) {
				do_action( 'progress_action_before_post_readmore' );
				progress_show_post_more_link( $progress_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'progress_action_after_post_readmore' );
			}
		}
		$progress_content = ob_get_contents();
		ob_end_clean();
		progress_show_layout($progress_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
