<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PROGRESS
 * @since PROGRESS 1.0.50
 */

$progress_template_args = get_query_var( 'progress_template_args' );
if ( is_array( $progress_template_args ) ) {
	$progress_columns    = empty( $progress_template_args['columns'] ) ? 2 : max( 1, $progress_template_args['columns'] );
	$progress_blog_style = array( $progress_template_args['type'], $progress_columns );
} else {
	$progress_template_args = array();
	$progress_blog_style = explode( '_', progress_get_theme_option( 'blog_style' ) );
	$progress_columns    = empty( $progress_blog_style[1] ) ? 2 : max( 1, $progress_blog_style[1] );
}
$progress_blog_id       = progress_get_custom_blog_id( join( '_', $progress_blog_style ) );
$progress_blog_style[0] = str_replace( 'blog-custom-', '', $progress_blog_style[0] );
$progress_expanded      = ! progress_sidebar_present() && progress_get_theme_option( 'expand_content' ) == 'expand';
$progress_components    = ! empty( $progress_template_args['meta_parts'] )
							? ( is_array( $progress_template_args['meta_parts'] )
								? join( ',', $progress_template_args['meta_parts'] )
								: $progress_template_args['meta_parts']
								)
							: progress_array_get_keys_by_value( progress_get_theme_option( 'meta_parts' ) );
$progress_post_format   = get_post_format();
$progress_post_format   = empty( $progress_post_format ) ? 'standard' : str_replace( 'post-format-', '', $progress_post_format );

$progress_blog_meta     = progress_get_custom_layout_meta( $progress_blog_id );
$progress_custom_style  = ! empty( $progress_blog_meta['scripts_required'] ) ? $progress_blog_meta['scripts_required'] : 'none';

if ( ! empty( $progress_template_args['slider'] ) || $progress_columns > 1 || ! progress_is_off( $progress_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $progress_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( progress_is_off( $progress_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $progress_custom_style ) ) . "-1_{$progress_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $progress_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $progress_columns )
					. ' post_layout_' . esc_attr( $progress_blog_style[0] )
					. ' post_layout_' . esc_attr( $progress_blog_style[0] ) . '_' . esc_attr( $progress_columns )
					. ( ! progress_is_off( $progress_custom_style )
						? ' post_layout_' . esc_attr( $progress_custom_style )
							. ' post_layout_' . esc_attr( $progress_custom_style ) . '_' . esc_attr( $progress_columns )
						: ''
						)
		);
	progress_add_blog_animation( $progress_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'progress_action_show_layout', $progress_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $progress_template_args['slider'] ) || $progress_columns > 1 || ! progress_is_off( $progress_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
