<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

$progress_template_args = get_query_var( 'progress_template_args' );
$progress_columns = 1;
if ( is_array( $progress_template_args ) ) {
	$progress_columns    = empty( $progress_template_args['columns'] ) ? 1 : max( 1, $progress_template_args['columns'] );
	$progress_blog_style = array( $progress_template_args['type'], $progress_columns );
	if ( ! empty( $progress_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $progress_columns > 1 ) {
	    $progress_columns_class = progress_get_column_class( 1, $progress_columns, ! empty( $progress_template_args['columns_tablet']) ? $progress_template_args['columns_tablet'] : '', ! empty($progress_template_args['columns_mobile']) ? $progress_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $progress_columns_class ); ?>">
		<?php
	}
} else {
	$progress_template_args = array();
}
$progress_expanded    = ! progress_sidebar_present() && progress_get_theme_option( 'expand_content' ) == 'expand';
$progress_post_format = get_post_format();
$progress_post_format = empty( $progress_post_format ) ? 'standard' : str_replace( 'post-format-', '', $progress_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $progress_post_format ) );
	progress_add_blog_animation( $progress_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$progress_hover      = ! empty( $progress_template_args['hover'] ) && ! progress_is_inherit( $progress_template_args['hover'] )
							? $progress_template_args['hover']
							: progress_get_theme_option( 'image_hover' );
	$progress_components = ! empty( $progress_template_args['meta_parts'] )
							? ( is_array( $progress_template_args['meta_parts'] )
								? $progress_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $progress_template_args['meta_parts'] ) )
								)
							: progress_array_get_keys_by_value( progress_get_theme_option( 'meta_parts' ) );
	progress_show_post_featured( apply_filters( 'progress_filter_args_featured',
		array(
			'no_links'   => ! empty( $progress_template_args['no_links'] ),
			'hover'      => $progress_hover,
			'meta_parts' => $progress_components,
			'thumb_size' => ! empty( $progress_template_args['thumb_size'] )
							? $progress_template_args['thumb_size']
							: progress_get_thumb_size( strpos( progress_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $progress_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$progress_template_args
	) );

	// Title and post meta
	$progress_show_title = get_the_title() != '';
	$progress_show_meta  = count( $progress_components ) > 0 && ! in_array( $progress_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $progress_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'progress_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'progress_action_before_post_title' );
				if ( empty( $progress_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'progress_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'progress_filter_show_blog_excerpt', empty( $progress_template_args['hide_excerpt'] ) && progress_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'progress_filter_show_blog_meta', $progress_show_meta, $progress_components, 'excerpt' ) ) {
				if ( count( $progress_components ) > 0 ) {
					do_action( 'progress_action_before_post_meta' );
					progress_show_post_meta(
						apply_filters(
							'progress_filter_post_meta_args', array(
								'components' => join( ',', $progress_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'progress_action_after_post_meta' );
				}
			}

			if ( progress_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'progress_action_before_full_post_content' );
					the_content( '' );
					do_action( 'progress_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'progress' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'progress' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				progress_show_post_content( $progress_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'progress_filter_show_blog_readmore',  ! isset( $progress_template_args['more_button'] ) || ! empty( $progress_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $progress_template_args['no_links'] ) ) {
					do_action( 'progress_action_before_post_readmore' );
					if ( progress_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						progress_show_post_more_link( $progress_template_args, '<p>', '</p>' );
					} else {
						progress_show_post_comments_link( $progress_template_args, '<p>', '</p>' );
					}
					do_action( 'progress_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $progress_template_args ) ) {
	if ( ! empty( $progress_template_args['slider'] ) || $progress_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
