<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

$progress_template_args = get_query_var( 'progress_template_args' );
if ( is_array( $progress_template_args ) ) {
	$progress_columns    = empty( $progress_template_args['columns'] ) ? 2 : max( 1, $progress_template_args['columns'] );
	$progress_blog_style = array( $progress_template_args['type'], $progress_columns );
    $progress_columns_class = progress_get_column_class( 1, $progress_columns, ! empty( $progress_template_args['columns_tablet']) ? $progress_template_args['columns_tablet'] : '', ! empty($progress_template_args['columns_mobile']) ? $progress_template_args['columns_mobile'] : '' );
} else {
	$progress_template_args = array();
	$progress_blog_style = explode( '_', progress_get_theme_option( 'blog_style' ) );
	$progress_columns    = empty( $progress_blog_style[1] ) ? 2 : max( 1, $progress_blog_style[1] );
    $progress_columns_class = progress_get_column_class( 1, $progress_columns );
}

$progress_post_format = get_post_format();
$progress_post_format = empty( $progress_post_format ) ? 'standard' : str_replace( 'post-format-', '', $progress_post_format );

?><div class="
<?php
if ( ! empty( $progress_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( progress_is_blog_style_use_masonry( $progress_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $progress_columns ) : esc_attr( $progress_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $progress_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $progress_columns )
		. ( 'portfolio' != $progress_blog_style[0] ? ' ' . esc_attr( $progress_blog_style[0] )  . '_' . esc_attr( $progress_columns ) : '' )
	);
	progress_add_blog_animation( $progress_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$progress_hover   = ! empty( $progress_template_args['hover'] ) && ! progress_is_inherit( $progress_template_args['hover'] )
								? $progress_template_args['hover']
								: progress_get_theme_option( 'image_hover' );

	if ( 'dots' == $progress_hover ) {
		$progress_post_link = empty( $progress_template_args['no_links'] )
								? ( ! empty( $progress_template_args['link'] )
									? $progress_template_args['link']
									: get_permalink()
									)
								: '';
		$progress_target    = ! empty( $progress_post_link ) && progress_is_external_url( $progress_post_link )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$progress_components = ! empty( $progress_template_args['meta_parts'] )
							? ( is_array( $progress_template_args['meta_parts'] )
								? $progress_template_args['meta_parts']
								: explode( ',', $progress_template_args['meta_parts'] )
								)
							: progress_array_get_keys_by_value( progress_get_theme_option( 'meta_parts' ) );

	// Featured image
	progress_show_post_featured( apply_filters( 'progress_filter_args_featured',
        array(
			'hover'         => $progress_hover,
			'no_links'      => ! empty( $progress_template_args['no_links'] ),
			'thumb_size'    => ! empty( $progress_template_args['thumb_size'] )
								? $progress_template_args['thumb_size']
								: progress_get_thumb_size(
									progress_is_blog_style_use_masonry( $progress_blog_style[0] )
										? (	strpos( progress_get_theme_option( 'body_style' ), 'full' ) !== false || $progress_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( progress_get_theme_option( 'body_style' ), 'full' ) !== false || $progress_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => progress_is_blog_style_use_masonry( $progress_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $progress_components,
			'class'         => 'dots' == $progress_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $progress_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $progress_post_link )
												? '<a href="' . esc_url( $progress_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $progress_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $progress_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $progress_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!