<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package PROGRESS
 * @since PROGRESS 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$progress_copyright_scheme = progress_get_theme_option( 'copyright_scheme' );
if ( ! empty( $progress_copyright_scheme ) && ! progress_is_inherit( $progress_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $progress_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$progress_copyright = progress_get_theme_option( 'copyright' );
			if ( ! empty( $progress_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$progress_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $progress_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$progress_copyright = progress_prepare_macros( $progress_copyright );
				// Display copyright
				echo wp_kses( nl2br( $progress_copyright ), 'progress_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
