<?php
/**
 * The template to display default site footer
 *
 * @package PROGRESS
 * @since PROGRESS 1.0.10
 */

$progress_footer_id = progress_get_custom_footer_id();
$progress_footer_meta = get_post_meta( $progress_footer_id, 'trx_addons_options', true );
if ( ! empty( $progress_footer_meta['margin'] ) ) {
	progress_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( progress_prepare_css_value( $progress_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $progress_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $progress_footer_id ) ) ); ?>
						<?php
						$progress_footer_scheme = progress_get_theme_option( 'footer_scheme' );
						if ( ! empty( $progress_footer_scheme ) && ! progress_is_inherit( $progress_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $progress_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'progress_action_show_layout', $progress_footer_id );
	?>
</footer><!-- /.footer_wrap -->
