<?php
/**
 * The template to display the site logo in the footer
 *
 * @package PROGRESS
 * @since PROGRESS 1.0.10
 */

// Logo
if ( progress_is_on( progress_get_theme_option( 'logo_in_footer' ) ) ) {
	$progress_logo_image = progress_get_logo_image( 'footer' );
	$progress_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $progress_logo_image['logo'] ) || ! empty( $progress_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $progress_logo_image['logo'] ) ) {
					$progress_attr = progress_getimagesize( $progress_logo_image['logo'] );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '">'
							. '<img src="' . esc_url( $progress_logo_image['logo'] ) . '"'
								. ( ! empty( $progress_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $progress_logo_image['logo_retina'] ) . ' 2x"' : '' )
								. ' class="logo_footer_image"'
								. ' alt="' . esc_attr__( 'Site logo', 'progress' ) . '"'
								. ( ! empty( $progress_attr[3] ) ? ' ' . wp_kses_data( $progress_attr[3] ) : '' )
							. '>'
						. '</a>';
				} elseif ( ! empty( $progress_logo_text ) ) {
					echo '<h1 class="logo_footer_text">'
							. '<a href="' . esc_url( home_url( '/' ) ) . '">'
								. esc_html( $progress_logo_text )
							. '</a>'
						. '</h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
