<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package PROGRESS
 * @since PROGRESS 1.0.10
 */

// Footer sidebar
$progress_footer_name    = progress_get_theme_option( 'footer_widgets' );
$progress_footer_present = ! progress_is_off( $progress_footer_name ) && is_active_sidebar( $progress_footer_name );
if ( $progress_footer_present ) {
	progress_storage_set( 'current_sidebar', 'footer' );
	$progress_footer_wide = progress_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $progress_footer_name ) ) {
		dynamic_sidebar( $progress_footer_name );
	}
	$progress_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $progress_out ) ) {
		$progress_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $progress_out );
		$progress_need_columns = true;   //or check: strpos($progress_out, 'columns_wrap')===false;
		if ( $progress_need_columns ) {
			$progress_columns = max( 0, (int) progress_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $progress_columns ) {
				$progress_columns = min( 4, max( 1, progress_tags_count( $progress_out, 'aside' ) ) );
			}
			if ( $progress_columns > 1 ) {
				$progress_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $progress_columns ) . ' widget', $progress_out );
			} else {
				$progress_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $progress_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'progress_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $progress_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $progress_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'progress_action_before_sidebar', 'footer' );
				progress_show_layout( $progress_out );
				do_action( 'progress_action_after_sidebar', 'footer' );
				if ( $progress_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $progress_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'progress_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
