<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package PROGRESS
 * @since PROGRESS 1.0.06
 */

$progress_header_css   = '';
$progress_header_image = get_header_image();
$progress_header_video = progress_get_header_video();
if ( ! empty( $progress_header_image ) && progress_trx_addons_featured_image_override( is_singular() || progress_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$progress_header_image = progress_get_current_mode_image( $progress_header_image );
}

$progress_header_id = progress_get_custom_header_id();
$progress_header_meta = get_post_meta( $progress_header_id, 'trx_addons_options', true );
if ( ! empty( $progress_header_meta['margin'] ) ) {
	progress_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( progress_prepare_css_value( $progress_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_<?php echo esc_attr( $progress_header_id ); ?> top_panel_custom_<?php echo esc_attr( sanitize_title( get_the_title( $progress_header_id ) ) ); ?>
				<?php
				echo ! empty( $progress_header_image ) || ! empty( $progress_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
				if ( '' != $progress_header_video ) {
					echo ' with_bg_video';
				}
				if ( '' != $progress_header_image ) {
					echo ' ' . esc_attr( progress_add_inline_css_class( 'background-image: url(' . esc_url( $progress_header_image ) . ');' ) );
				}
				if ( is_single() && has_post_thumbnail() ) {
					echo ' with_featured_image';
				}
				if ( progress_is_on( progress_get_theme_option( 'header_fullheight' ) ) ) {
					echo ' header_fullheight progress-full-height';
				}
				$progress_header_scheme = progress_get_theme_option( 'header_scheme' );
				if ( ! empty( $progress_header_scheme ) && ! progress_is_inherit( $progress_header_scheme  ) ) {
					echo ' scheme_' . esc_attr( $progress_header_scheme );
				}
				?>
">
	<?php

	// Background video
	if ( ! empty( $progress_header_video ) ) {
		get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/header-video' ) );
	}

	// Custom header's layout
	do_action( 'progress_action_show_layout', $progress_header_id );

	// Header widgets area
	get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/header-widgets' ) );

	?>
</header>
