<?php
/**
 * The template to display default site header
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

$progress_header_css   = '';
$progress_header_image = get_header_image();
$progress_header_video = progress_get_header_video();
if ( ! empty( $progress_header_image ) && progress_trx_addons_featured_image_override( is_singular() || progress_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$progress_header_image = progress_get_current_mode_image( $progress_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $progress_header_image ) || ! empty( $progress_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $progress_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $progress_header_image ) {
		echo ' ' . esc_attr( progress_add_inline_css_class( 'background-image: url(' . esc_url( $progress_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( progress_is_on( progress_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight progress-full-height';
	}
	$progress_header_scheme = progress_get_theme_option( 'header_scheme' );
	if ( ! empty( $progress_header_scheme ) && ! progress_is_inherit( $progress_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $progress_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $progress_header_video ) ) {
		get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( progress_is_on( progress_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'progress_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
