<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

$progress_args = get_query_var( 'progress_logo_args' );

// Site logo
$progress_logo_type   = isset( $progress_args['type'] ) ? $progress_args['type'] : '';
$progress_logo_image  = progress_get_logo_image( $progress_logo_type );
$progress_logo_text   = progress_is_on( progress_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$progress_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $progress_logo_image['logo'] ) || ! empty( $progress_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $progress_logo_image['logo'] ) ) {
			if ( empty( $progress_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($progress_logo_image['logo']) && (int) $progress_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$progress_attr = progress_getimagesize( $progress_logo_image['logo'] );
				echo '<img src="' . esc_url( $progress_logo_image['logo'] ) . '"'
						. ( ! empty( $progress_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $progress_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $progress_logo_text ) . '"'
						. ( ! empty( $progress_attr[3] ) ? ' ' . wp_kses_data( $progress_attr[3] ) : '' )
						. '>';
			}
		} else {
			progress_show_layout( progress_prepare_macros( $progress_logo_text ), '<span class="logo_text">', '</span>' );
			progress_show_layout( progress_prepare_macros( $progress_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
