<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

// Page (category, tag, archive, author) title

if ( progress_need_page_title() ) {
	progress_sc_layouts_showed( 'title', true );
	progress_sc_layouts_showed( 'postmeta', true );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_center">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_center">
						<?php
						// Post meta on the single post
						if ( is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								progress_show_post_meta(
									apply_filters(
										'progress_filter_post_meta_args', array(
											'components' => join( ',', progress_array_get_keys_by_value( progress_get_theme_option( 'meta_parts' ) ) ),
											'counters'   => join( ',', progress_array_get_keys_by_value( progress_get_theme_option( 'counters' ) ) ),
											'seo'        => progress_is_on( progress_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
							<?php
							$progress_blog_title           = progress_get_blog_title();
							$progress_blog_title_text      = '';
							$progress_blog_title_class     = '';
							$progress_blog_title_link      = '';
							$progress_blog_title_link_text = '';
							if ( is_array( $progress_blog_title ) ) {
								$progress_blog_title_text      = $progress_blog_title['text'];
								$progress_blog_title_class     = ! empty( $progress_blog_title['class'] ) ? ' ' . $progress_blog_title['class'] : '';
								$progress_blog_title_link      = ! empty( $progress_blog_title['link'] ) ? $progress_blog_title['link'] : '';
								$progress_blog_title_link_text = ! empty( $progress_blog_title['link_text'] ) ? $progress_blog_title['link_text'] : '';
							} else {
								$progress_blog_title_text = $progress_blog_title;
							}
							?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $progress_blog_title_class ); ?>">
								<?php
								$progress_top_icon = progress_get_term_image_small();
								if ( ! empty( $progress_top_icon ) ) {
									$progress_attr = progress_getimagesize( $progress_top_icon );
									?>
									<img src="<?php echo esc_url( $progress_top_icon ); ?>" alt="<?php esc_attr_e( 'Site icon', 'progress' ); ?>"
										<?php
										if ( ! empty( $progress_attr[3] ) ) {
											progress_show_layout( $progress_attr[3] );
										}
										?>
									>
									<?php
								}
								echo wp_kses_data( $progress_blog_title_text );
								?>
							</h1>
							<?php
							if ( ! empty( $progress_blog_title_link ) && ! empty( $progress_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $progress_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $progress_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( ! is_paged() && ( is_category() || is_tag() || is_tax() ) ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						// Breadcrumbs
						ob_start();
						do_action( 'progress_action_breadcrumbs' );
						$progress_breadcrumbs = ob_get_contents();
						ob_end_clean();
						progress_show_layout( $progress_breadcrumbs, '<div class="sc_layouts_title_breadcrumbs">', '</div>' );
						?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
