<?php
/**
 * The template to display the widgets area in the header
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

// Header sidebar
$progress_header_name    = progress_get_theme_option( 'header_widgets' );
$progress_header_present = ! progress_is_off( $progress_header_name ) && is_active_sidebar( $progress_header_name );
if ( $progress_header_present ) {
	progress_storage_set( 'current_sidebar', 'header' );
	$progress_header_wide = progress_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $progress_header_name ) ) {
		dynamic_sidebar( $progress_header_name );
	}
	$progress_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $progress_widgets_output ) ) {
		$progress_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $progress_widgets_output );
		$progress_need_columns   = strpos( $progress_widgets_output, 'columns_wrap' ) === false;
		if ( $progress_need_columns ) {
			$progress_columns = max( 0, (int) progress_get_theme_option( 'header_columns' ) );
			if ( 0 == $progress_columns ) {
				$progress_columns = min( 6, max( 1, progress_tags_count( $progress_widgets_output, 'aside' ) ) );
			}
			if ( $progress_columns > 1 ) {
				$progress_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $progress_columns ) . ' widget', $progress_widgets_output );
			} else {
				$progress_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $progress_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'progress_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $progress_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $progress_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'progress_action_before_sidebar', 'header' );
				progress_show_layout( $progress_widgets_output );
				do_action( 'progress_action_after_sidebar', 'header' );
				if ( $progress_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $progress_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'progress_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
