<?php
/**
 * The template 'Style 1' to displaying related posts
 *
 * @package PROGRESS
 * @since PROGRESS 1.0
 */

$progress_link        = get_permalink();
$progress_post_format = get_post_format();
$progress_post_format = empty( $progress_post_format ) ? 'standard' : str_replace( 'post-format-', '', $progress_post_format );
?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item post_format_' . esc_attr( $progress_post_format ) ); ?> data-post-id="<?php the_ID(); ?>">
	<?php
	progress_show_post_featured(
		array(
			'thumb_size'    => apply_filters( 'progress_filter_related_thumb_size', progress_get_thumb_size( (int) progress_get_theme_option( 'related_posts' ) == 1 ? 'huge' : 'big' ) ),
			'post_info'     => '<div class="post_header entry-header">'
									. '<div class="post_categories">' . wp_kses( progress_get_post_categories( '' ), 'progress_kses_content' ) . '</div>'
									. '<h6 class="post_title entry-title"><a href="' . esc_url( $progress_link ) . '">'
										. wp_kses_data( '' == get_the_title() ? esc_html__( '- No title -', 'progress' ) : get_the_title() )
									. '</a></h6>'
									. ( in_array( get_post_type(), array( 'post', 'attachment' ) )
											? '<div class="post_meta"><a href="' . esc_url( $progress_link ) . '" class="post_meta_item post_date">' . wp_kses_data( progress_get_date() ) . '</a></div>'
											: '' )
								. '</div>',
		)
	);
	?>
</div>
