<?php
/**
 * The default template to displaying related posts
 *
 * @package PROGRESS
 * @since PROGRESS 1.0.54
 */

$progress_link        = get_permalink();
$progress_post_format = get_post_format();
$progress_post_format = empty( $progress_post_format ) ? 'standard' : str_replace( 'post-format-', '', $progress_post_format );
?><div id="post-<?php the_ID(); ?>" <?php post_class( 'related_item post_format_' . esc_attr( $progress_post_format ) ); ?> data-post-id="<?php the_ID(); ?>">
	<?php
	progress_show_post_featured(
		array(
			'thumb_size' => apply_filters( 'progress_filter_related_thumb_size', progress_get_thumb_size( (int) progress_get_theme_option( 'related_posts' ) == 1 ? 'huge' : 'big' ) ),
		)
	);
	?>
	<div class="post_header entry-header">
		<h6 class="post_title entry-title"><a href="<?php echo esc_url( $progress_link ); ?>"><?php
			if ( '' == get_the_title() ) {
				esc_html_e( '- No title -', 'progress' );
			} else {
				the_title();
			}
		?></a></h6>
		<?php
		if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
			?>
			<span class="post_date"><a href="<?php echo esc_url( $progress_link ); ?>"><?php echo wp_kses_data( progress_get_date() ); ?></a></span>
			<?php
		}
		?>
	</div>
</div>
