<?php
/**
 * The template to display Admin notices
 *
 * @package PROGRESS
 * @since PROGRESS 1.0.64
 */

$progress_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$progress_skins_args = get_query_var( 'progress_skins_notice_args' );
?>
<div class="progress_admin_notice progress_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$progress_theme_img = progress_get_file_url( 'screenshot.jpg' );
	if ( '' != $progress_theme_img ) {
		?>
		<div class="progress_notice_image"><img src="<?php echo esc_url( $progress_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'progress' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="progress_notice_title">
		<?php esc_html_e( 'New skins are available', 'progress' ); ?>
	</h3>
	<?php

	// Description
	$progress_total      = $progress_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$progress_skins_msg  = $progress_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $progress_total, 'progress' ), $progress_total ) . '</strong>'
							: '';
	$progress_total      = $progress_skins_args['free'];
	$progress_skins_msg .= $progress_total > 0
							? ( ! empty( $progress_skins_msg ) ? ' ' . esc_html__( 'and', 'progress' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $progress_total, 'progress' ), $progress_total ) . '</strong>'
							: '';
	$progress_total      = $progress_skins_args['pay'];
	$progress_skins_msg .= $progress_skins_args['pay'] > 0
							? ( ! empty( $progress_skins_msg ) ? ' ' . esc_html__( 'and', 'progress' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $progress_total, 'progress' ), $progress_total ) . '</strong>'
							: '';
	?>
	<div class="progress_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'progress' ), $progress_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="progress_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $progress_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'progress' );
			?>
		</a>
	</div>
</div>
