<?php 

if ( !function_exists('puca_tbay_private_size_image_setup') ) {
	function puca_tbay_private_size_image_setup() {

		/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* See: https://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
		*/
		add_image_size('puca_avatar_post_carousel', 45, 45, true); //(cropped)


		if( !puca_tbay_get_global_config('config_media',false) ) {
			// Post Thumbnails Size
			set_post_thumbnail_size(570, 320, true); // Unlimited height, soft crop

			update_option('thumbnail_size_w', 570);
			update_option('thumbnail_size_h', 320);						

			update_option('medium_size_w', 555);
			update_option('medium_size_h', 360);
		}

	}
	add_action( 'after_setup_theme', 'puca_tbay_private_size_image_setup' );
}

if ( !function_exists('puca_tbay_private_menu_setup') ) {
	function puca_tbay_private_menu_setup() {

		// This theme uses wp_nav_menu() in two locations.
		register_nav_menus( array(
			'primary' 		=> esc_html__( 'Primary Menu', 'puca' ),
			'mobile-menu' 	=> esc_html__( 'Mobile Menu','puca' ),
			'topmenu'  		=> esc_html__( 'Top Menu', 'puca' ),
			'nav-account'  	=> esc_html__( 'Nav Account', 'puca' ),
			'footer-menu'  	=> esc_html__( 'Footer Menu', 'puca' ),
		) );

	}
	add_action( 'after_setup_theme', 'puca_tbay_private_menu_setup' );
}

if (! function_exists('puca_tbay_class_flash_sale')) {
    function puca_tbay_class_flash_sale($flash_sales)
    {
        global $product;

        if (isset($flash_sales) && $flash_sales) {
            $class_sale    = (!$product->is_on_sale()) ? 'tbay-not-flash-sale' : '';
            return $class_sale; 
        }
    }
}
if (!function_exists('puca_tbay_stock_flash_sale')) {
    function puca_tbay_stock_flash_sale($flash_sales = '')
    {
        global $product;

        if ($flash_sales && $product->get_manage_stock()) : ?>
            <div class="stock-flash-sale stock">
                <?php
                $total_sales        = $product->get_total_sales();
				$stock_quantity     = $product->get_stock_quantity();
						
				$total_quantity   = (int)$total_sales + (int)$stock_quantity;
      			?>
		<span class="tb-sold"><span class="title-sold"><?php echo esc_html__('Sold', 'puca'); ?></span> <span class="sold"><?php echo esc_html($total_sales) ?></span><span class="total">/<?php echo esc_html($total_quantity) ?></span></span></div>
        <?php endif;
    }
}


if (!function_exists('puca_tbay_label_flash_sale')) {
    function puca_tbay_label_flash_sale()
    {
        $dates = array(
			'days' => esc_html__('','puca'),
			'hours' => esc_html__('','puca'),
			'mins' => esc_html__('','puca'), 
			'secs' => esc_html__('','puca'),
 
		); 
        return $dates;
    }
} 

if (! function_exists('puca_tbay_item_deal_ended_flash_sale')) {
    function puca_tbay_item_deal_ended_flash_sale($flash_sales, $end_date)
    {
        global $product;
    
        $today      = strtotime("today");

        if ($today > $end_date) {
            return;
        }

        $output = '';
        if (isset($flash_sales) && $flash_sales && !$product->is_on_sale()) {
            $output .= '<div class="item-deal-ended">';
            $output .= '<span>'. esc_html__('Deal ended', 'puca') .'</span>';
            $output .= '</div>';
        }
        echo trim($output);
    }
} 

if (!function_exists('puca_tbay_countdown_flash_sale')) {
    function puca_tbay_countdown_flash_sale($time_sale = '', $date_title = '', $date_title_ended = '', $strtotime = false)
    {
        wp_enqueue_script('jquery-countdowntimer');
        $_id        = puca_tbay_random_key();

        $today      = strtotime("today");
       
        $dates = puca_tbay_label_flash_sale();
        $days = $dates['days'];
        $hours = $dates['hours'];
        $mins = $dates['mins'];
        $secs = $dates['secs'];
        if ($strtotime) {
            $time_sale = strtotime($time_sale);
        } ?>
        <?php if (!empty($time_sale)) : ?>
            <div class="flash-sales-date">
                <?php if (($today <= $time_sale)): ?>
                    <?php if (isset($date_title) && !empty($date_title)) :  ?>
                        <div class="date-title"><?php echo trim($date_title); ?></div>
                    <?php endif; ?>
                    <div class="time">
                        <div class="tbay-countdown scroll-init" id="tbay-flash-sale-<?php echo esc_attr($_id); ?>" data-time="timmer"
                             data-date="<?php echo date('m', $time_sale).'-'.date('d', $time_sale).'-'.date('Y', $time_sale).'-'. date('H', $time_sale) . '-' . date('i', $time_sale) . '-' .  date('s', $time_sale) ; ?>" data-days="<?php echo esc_attr($days); ?>" data-hours="<?php echo esc_attr($hours); ?>" data-mins="<?php echo esc_attr($mins); ?>" data-secs="<?php echo esc_attr($secs); ?>" >
                        </div> 
                    </div>
                <?php else: ?>
                    
                <?php if (isset($date_title_ended) && !empty($date_title_ended)) :  ?>
                    <div class="date-title"><?php echo trim($date_title_ended); ?></div>
                <?php endif; ?>
            <?php endif; ?> 
            </div> 
        <?php endif; ?> 
        <?php
    }
}


/**
 *  Include Load Google Front
 */

if ( !function_exists('puca_fonts_url') ) {
	function puca_fonts_url() {
		$transient_key = 'puca_fonts_url';
		$fonts_url = get_transient($transient_key);

		if (!$fonts_url || (defined('WP_DEBUG') && WP_DEBUG === true ) ) {
			/**
			 * Load Google Front
			 */

			$fonts_url = '';

			/* Translators: If there are characters in your language that are not
			* supported by Montserrat, translate this to 'off'. Do not translate
			* into your own language.
			*/
			$Inter 		= _x( 'on', 'Inter font: on or off', 'puca' );
		
			if ( 'off' !== $Inter ) {
				$font_families = array();
		
				if ( 'off' !== $Inter ) {
					$font_families[] = 'Inter:400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
				}
				
		
				$query_args = array(
					'family' => ( implode( '%7C', $font_families ) ),
					'subset' => urlencode( 'latin,latin-ext' ),
					'display' => urlencode( 'swap' ),
				);
				
				$protocol = is_ssl() ? 'https:' : 'http:';
				$fonts_url = add_query_arg( $query_args, $protocol .'//fonts.googleapis.com/css' );
			}

		   	set_transient($transient_key, $fonts_url, WEEK_IN_SECONDS);
		}

	    return esc_url_raw( $fonts_url );
	}
}

if ( !function_exists('puca_tbay_fonts_url') ) {
	function puca_tbay_fonts_url() {  
		$protocol 		  = is_ssl() ? 'https:' : 'http:';
		$show_typography  = puca_tbay_get_config('show_typography', false);
		$font_source 	  = puca_tbay_get_config('font_source', "1");
		$font_google_code = puca_tbay_get_config('font_google_code');
		if( !$show_typography ) {
			wp_enqueue_style( 'puca-theme-fonts', puca_fonts_url(), array(), null );
		} else if ( $font_source == "2" && !empty($font_google_code) ) {
			wp_enqueue_style( 'puca-theme-fonts', $font_google_code, array(), null );
		}
	}
	add_action('wp_enqueue_scripts', 'puca_tbay_fonts_url');
}

/**
 * Register Sidebar
 *
 */
if ( !function_exists('puca_tbay_widgets_init') ) {
	function puca_tbay_widgets_init() {
		
		
		/* Check Redux */
		if( defined('PUCA_REDUX_FRAMEWORK_ACTIVED') && PUCA_REDUX_FRAMEWORK_ACTIVED ) {
			register_sidebar( array(
				'name'          => esc_html__( 'Top Shipping', 'puca' ),
				'id'            => 'top-shipping',
				'description'   => esc_html__( 'Add widgets here to appear in Top Shipping. (Only Show On Home Page)', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );	

			register_sidebar( array(
				'name'          => esc_html__( 'Top Left Header V4', 'puca' ),
				'id'            => 'top-left-header-v4',
				'description'   => esc_html__( 'Add widgets here to appear in Top Shipping.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );	

			register_sidebar( array(
				'name'          => esc_html__( 'Top Right Header V4', 'puca' ),
				'id'            => 'top-right-header-v4',
				'description'   => esc_html__( 'Add widgets here to appear in Top Shipping.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>', 
			) );		    	

			register_sidebar( array(
				'name'          => esc_html__( 'Product Top Shop Full Width', 'puca' ),
				'id'            => 'product-top-sidebar',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );				

			register_sidebar( array(
				'name'          => esc_html__( 'Product Top Shop Multi Viewed', 'puca' ),
				'id'            => 'product-top-multi-viewed-sidebar',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );

			register_sidebar( array(
				'name'          => esc_html__( 'Product Canvas Sidebar', 'puca' ),
				'id'            => 'product-canvas-sidebar',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );				

			register_sidebar( array(
				'name'          => esc_html__( 'Blog Top Search Sidebar', 'puca' ),
				'id'            => 'blog-top-search',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );					

			register_sidebar( array(
				'name'          => esc_html__( 'Blog Top Sidebar', 'puca' ),
				'id'            => 'blog-top-sidebar1',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );				

			register_sidebar( array(
				'name'          => esc_html__( 'Blog Top Sidebar 2', 'puca' ),
				'id'            => 'blog-top-sidebar2',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );

			register_sidebar( array(
				'name'          => esc_html__( 'Blog Left sidebar 2', 'puca' ),
				'id'            => 'blog-left-sidebar-45',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );
			
			register_sidebar( array(
				'name'          => esc_html__( 'Blog Right Sidebar 2', 'puca' ),
				'id'            => 'blog-right-sidebar-45',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );
		}
		/* End Check Redux */

		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar Default', 'puca' ),
			'id'            => 'sidebar-default',
			'description'   => esc_html__( 'Add widgets here to appear in your Sidebar.', 'puca' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) );
		
		/* Check Redux */
		if( defined('PUCA_REDUX_FRAMEWORK_ACTIVED') && PUCA_REDUX_FRAMEWORK_ACTIVED ) {
		
			register_sidebar( array(
				'name'          => esc_html__( 'Blog left sidebar', 'puca' ),
				'id'            => 'blog-left-sidebar',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );
			register_sidebar( array(
				'name'          => esc_html__( 'Blog right sidebar', 'puca' ),
				'id'            => 'blog-right-sidebar',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );

		
			register_sidebar( array(
				'name'          => esc_html__( 'Product left sidebar', 'puca' ),
				'id'            => 'product-left-sidebar',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );
			register_sidebar( array(
				'name'          => esc_html__( 'Product right sidebar', 'puca' ),
				'id'            => 'product-right-sidebar',
				'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
				'before_widget' => '<aside id="%1$s" class="widget %2$s">',
				'after_widget'  => '</aside>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			) );
		}
		/* End Check Redux */
		
		register_sidebar( array(
			'name'          => esc_html__( 'Footer', 'puca' ),
			'id'            => 'footer',
			'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'puca' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		) );
		
	}
	add_action( 'widgets_init', 'puca_tbay_widgets_init' );
}

if ( !function_exists( 'puca_tbay_autocomplete_search' ) ) { 
    function puca_tbay_autocomplete_search() {
    	wp_enqueue_script('jquery-ui-autocomplete');
        if ( puca_tbay_get_global_config('autocomplete_search') ) {
            add_action( 'wp_ajax_puca_autocomplete_search', 'puca_tbay_autocomplete_suggestions' );
            add_action( 'wp_ajax_nopriv_puca_autocomplete_search', 'puca_tbay_autocomplete_suggestions' );
        }
    }
}
add_action( 'init', 'puca_tbay_autocomplete_search' );

if ( !function_exists( 'puca_tbay_autocomplete_suggestions' ) ) {
    function puca_tbay_autocomplete_suggestions() {
        $nonce = isset($_POST['nonce']) ? wp_unslash($_POST['nonce']) : (isset($_GET['nonce']) ? wp_unslash($_GET['nonce']) : '');
        if (empty($nonce) || !wp_verify_nonce($nonce, 'puca_ajax_nonce')) {
            wp_die();
        }

        $input = array_map('sanitize_text_field', $_REQUEST);

        $search_keyword = $input['term'] ?? '';
        if (empty($search_keyword)) {
            wp_send_json(['suggestions' => []]);
            return;
        }

        $style = $input['style'] ?? '';
        $post_type = $input['post_type'] ?? '';
        $category = $input['category'] ?? '';

        $number = puca_tbay_get_config('search_max_number_results', 5);
        $show_image = puca_tbay_get_config('show_search_product_image', true);
        $show_price = puca_tbay_get_config('search_type') == 'product' ? puca_tbay_get_config('show_search_product_price') : false;

        $args = array(
            's'                   => $search_keyword,
            'post_status'         => 'publish',
            'orderby'             => 'relevance',
            'posts_per_page'      => $number,
            'ignore_sticky_posts' => true,
            'cache_results'       => true,
            'suppress_filters'    => false,
        );

        if ( $post_type && $post_type !== 'all' ) {
            $args['post_type'] = $post_type;
        }

        if ( $post_type && $post_type !== 'post' && class_exists( 'WooCommerce' ) ) {
            $args['meta_query'] = WC()->query->get_meta_query();
            $args['tax_query']  = WC()->query->get_tax_query();

            if ( apply_filters( 'puca_search_query_in', puca_tbay_get_config('search_query_in', 'title') === 'all' ) ) {
                add_filter( 'posts_search', 'puca_product_ajax_search_sku', 9 );
            } else {
                add_filter( 'posts_search', 'puca_product_search_title', 20, 2);
            }
        }

        if ( class_exists( 'WooCommerce' ) && $post_type === 'product' ) {
            $product_visibility_term_ids = wc_get_product_visibility_term_ids();
            $args['tax_query']['relation'] = 'AND';

            $args['tax_query'][] = array(
                'taxonomy' => 'product_visibility',
                'field'    => 'term_taxonomy_id',
                'terms'    => $product_visibility_term_ids['exclude-from-search'],
                'operator' => 'NOT IN',
            );

            if ( !empty($category) ) {
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_cat',
                    'field'    => 'slug',
                    'terms'    => $category,
                );
            }
        }

        $results = new WP_Query($args);

        $suggestions = array();
        $count = $results->found_posts;
        $view_all = ($count > $number);

        while ( $results->have_posts() ) : $results->the_post();
            $suggestion = array();
            $suggestion['label'] = esc_html(get_the_title());
            $suggestion['style'] = $style;
            $suggestion['link'] = get_permalink();
            $suggestion['result'] = $count.' '. esc_html__('result found with', 'puca') .' "'.$search_keyword.'" ';
            $suggestion['view_all'] = $view_all;

            if ( $show_image && has_post_thumbnail( get_the_ID() ) ) {
                $image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'woocommerce_thumbnail' );
                $suggestion['image'] = $image[0] ?? '';
            } else {
                $suggestion['image'] = '';
            }

            if ( $show_price ) {
                $product = wc_get_product( get_the_ID() );
                $suggestion['price'] = $product ? $product->get_price_html() : '';
            } else {
                $suggestion['price'] = '';
            }

            if ( $post_type === 'product' && isset($product) && $product ) {
                $suggestion['sku'] = ( puca_tbay_get_config('search_query_in', 'title') === 'all' && puca_tbay_get_config('search_sku_ajax', false) && $product->get_sku() ) ? esc_html__( 'SKU:', 'puca' ) . ' ' . $product->get_sku() : '';
            }

            $suggestions[] = $suggestion;
        endwhile;

        wp_reset_postdata();

        $callback = isset($_GET['callback']) ? preg_replace('/[^a-zA-Z0-9_]/', '', $_GET['callback']) : 'callback';
        header('Content-Type: application/javascript');
        echo esc_html($callback) . '(' . wp_json_encode($suggestions) . ');';
        exit;
    }
}


if ( !function_exists('puca_tbay_get_blog_layout_configs') ) {
	function puca_tbay_get_blog_layout_configs() {
		$page = 'archive';
		if ( is_singular( 'post' ) ) {
            $page = 'single';
    } else {
			$left2 = puca_tbay_get_config('blog_'.$page.'_left_sidebar45');
			$right2 = puca_tbay_get_config('blog_'.$page.'_right_sidebar45'); 	
    }

		$left = puca_tbay_get_config('blog_'.$page.'_left_sidebar','blog-left-sidebar');
		$right = puca_tbay_get_config('blog_'.$page.'_right_sidebar','blog-right-sidebar');



		if ( !is_singular( 'post' ) ) {

			$blog_archive_layout =  ( isset($_GET['blog_archive_layout']) )  ? $_GET['blog_archive_layout'] : puca_tbay_get_config('blog_archive_layout', 'main-right-v1');
			if( isset($blog_archive_layout) ) {

				switch ( $blog_archive_layout ) {
					case 'main-v1':
				 		$configs['main'] 				= array( 'class' => 'style-grid archive-full' );
				 		$configs['columns'] 			= 3;
				 		$configs['image_sizes'] 		= 'post-thumbnail';
				 		break;							 	
				 	case 'main-v2':
				 		$configs['main'] 				= array( 'class' => 'style-grid archive-full style-center' );
				 		$configs['columns'] 			= 1;
				 		$configs['image_sizes'] 		= 'full';
				 		break;							 	
				 	case 'main-v3':
				 		$configs['main'] 				= array( 'class' => 'archive-full' );
				 		$configs['columns'] 			= 2;
				 		$configs['image_sizes'] 		= 'post-thumbnail';
				 		break;							 	
				 	case 'main-v4':
				 		$configs['main'] 				= array( 'class' => 'archive-full' );
				 		$configs['container_full'] 		= true;
				 		$configs['columns'] 			= 4;
				 		$configs['image_sizes'] 		= 'post-thumbnail';
				 		break;							 	
				 	case 'left-main-v1':
				 		$configs['left'] 				= array( 'sidebar' => $left, 'class' => 'col-xs-12 col-md-12 col-lg-4'  );
				 		$configs['main'] 				= array( 'class' => 'style-grid col-xs-12 col-md-12 col-lg-8' );
				 		$configs['columns'] 			= 2;
				 		$configs['image_sizes'] 		= 'post-thumbnail';
				 		break;							 	
				 	case 'main-right-v1':
				 		$configs['right'] 				= array( 'sidebar' => $right,  'class' => 'col-xs-12 col-md-12 col-lg-4' ); 
				 		$configs['main'] 				= array( 'class' => 'style-grid col-xs-12 col-md-12 col-lg-8' );
				 		$configs['columns'] 			= 2;
				 		$configs['image_sizes'] 		= 'post-thumbnail';
				 		break;			
				 	case 'left-main-v2':
				 		$configs['left'] 						= array( 'sidebar' => $left, 'class' => 'col-xs-12 col-md-12 col-lg-4'  );
				 		$configs['main'] 						= array( 'class' => 'style-grid style-center col-xs-12 col-md-12 col-lg-8' );
				 		$configs['columns'] 				= 1;
				 		$configs['image_sizes'] 		= 'full';
				 		break;		
				 	case 'main-right-v2':
				 		$configs['right'] 					= array( 'sidebar' => $right,  'class' => 'col-xs-12 col-md-12 col-lg-4' ); 
				 		$configs['main'] 						= array( 'class' => 'style-grid style-center col-xs-12 col-md-12 col-lg-8' );
				 		$configs['columns'] 				= 1;
				 		$configs['image_sizes'] 		= 'full';
				 		break;							 	
				 	case 'left-main-v3':
				 		$configs['left'] 						= array( 'sidebar' => $left, 'class' => 'col-xs-12 col-md-12 col-lg-4'  );
				 		$configs['main'] 						= array( 'class' => 'style-list col-xs-12 col-md-12 col-lg-8' );
				 		$configs['columns'] 				= 1;
				 		$configs['image_sizes'] 		= 'post-thumbnail';
				 		break;		
				 	case 'main-right-v3':
				 		$configs['right'] 					= array( 'sidebar' => $right,  'class' => 'col-xs-12 col-md-12 col-lg-4' ); 
				 		$configs['main'] 						= array( 'class' => 'style-list col-xs-12 col-md-12 col-lg-8' );
				 		$configs['columns'] 				= 1;
				 		$configs['image_sizes'] 		= 'post-thumbnail';
						break;
				 	case 'left-main-v4':
				 		$configs['left'] 						= array( 'sidebar' => $left2, 'class' => 'col-xs-12 col-md-12 col-lg-4'  );
				 		$configs['main']	 						= array( 'class' => 'style-grid col-xs-12 col-md-12 col-lg-8' );
				 		$configs['blog_top_sidebar1'] 	= true;
				 		$configs['blog_top_search'] 	= true;
				 		$configs['columns'] 					= 2;
				 		$configs['image_sizes'] 			= 'post-thumbnail';	
				 		break;		 
				 	case 'main-right-v4':
				 		$configs['right'] 						= array( 'sidebar' => $right2,  'class' => 'col-xs-12 col-md-12 col-lg-4' ); 
				 		$configs['main'] 							= array( 'class' => 'style-grid col-xs-12 col-md-12 col-lg-8' );
				 		$configs['blog_top_sidebar1'] 	= true;
				 		$configs['blog_top_search'] 	= true;
				 		$configs['columns'] 					= 2;
				 		$configs['image_sizes'] 			= 'post-thumbnail';	
				 		break;								 	
				 	case 'left-main-v5':
				 		$configs['left'] 							= array( 'sidebar' => $left2, 'class' => 'col-xs-12 col-md-12 col-lg-4'  );
				 		$configs['main'] 							= array( 'class' => 'style-grid col-xs-12 col-md-12 col-lg-8' );
				 		$configs['blog_top_sidebar2'] = true;
				 		$configs['blog_top_search'] 	= true;
				 		$configs['columns'] 					= 2;
				 		$configs['image_sizes'] 			= 'full'; 	
				 		break;		
				 	case 'main-right-v5':
				 		$configs['right'] 						= array( 'sidebar' => $right2,  'class' => 'col-xs-12 col-md-12 col-lg-4' ); 
				 		$configs['main'] 							= array( 'class' => 'style-grid col-xs-12 col-md-12 col-lg-8' );
				 		$configs['blog_top_sidebar2'] = true;
				 		$configs['blog_top_search'] 	= true; 
				 		$configs['columns'] 					= 2;
				 		$configs['image_sizes'] 			= 'full'; 	
				 		break;		
				 	default:
				 		$configs['main'] = array( 'class' => 'archive-full' );
				 		break;
	      }
			}

		} else {

				$blog_single_layout =	( isset($_GET['blog_single_layout']) ) ? $_GET['blog_single_layout']  :  puca_tbay_get_config('blog_single_layout', 'left-main');

				if( isset($blog_single_layout) ) {

					switch ( $blog_single_layout ) {
					 	case 'left-main':
					 		$configs['left'] = array( 'sidebar' => $left, 'class' => 'col-xs-12 col-md-12 col-lg-4'  );
					 		$configs['main'] = array( 'class' => 'col-xs-12 col-md-12 col-lg-8' );
					 		break;
					 	case 'main-right':
					 		$configs['right'] = array( 'sidebar' => $right,  'class' => 'col-xs-12 col-md-12 col-lg-4' ); 
					 		$configs['main'] = array( 'class' => 'col-xs-12 col-md-12 col-lg-8' );
					 		break;
				 		case 'main':
				 			$configs['main'] = array( 'class' => 'col-xs-12 col-md-12' );
				 			break;
			 			case 'left-main-right':
			 				$configs['left'] = array( 'sidebar' => $left,  'class' => 'col-xs-12 col-md-12 col-lg-4'  );
					 		$configs['right'] = array( 'sidebar' => $right, 'class' => 'col-xs-12 col-md-12 col-lg-4' ); 
					 		$configs['main'] = array( 'class' => 'col-xs-12 col-md-12 col-lg-4' );
			 				break;
					 	default:
					 		$configs['main'] = array( 'class' => 'col-xs-12 col-md-12' );
					 		break;
					 }

				} 
		}


		return $configs; 
	}
}

