<?php

if ( ! defined( 'ABSPATH' ) || function_exists('Puca_Elementor_Supermaket_Categories_Tabs') ) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;


/**
 * Elementor tabs widget.
 *
 * Elementor widget that displays vertical or horizontal tabs with different
 * pieces of content.
 *
 * @since 1.0.0
 */
class Puca_Elementor_Supermaket_Categories_Tabs extends  Puca_Elementor_Carousel_Base{
    /**
     * Get widget name.
     *
     * Retrieve tabs widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'tbay-supermaket-categories-tabs';
    }
   
    /**
     * Get widget title.
     *
     * Retrieve tabs widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'Puca Supermaket Categories Tabs', 'puca' );
    }
    public function get_categories() {
        return [ 'puca-elements', 'woocommerce-elements'];
    }
 
    /**
     * Get widget icon.
     *
     * Retrieve tabs widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-product-tabs';
    }

    /**
     * Register tabs widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    public function get_script_depends()
    {
        return [ 'slick', 'puca-custom-slick' ];
    }

    public function get_keywords() {
        return [ 'woocommerce-elements', 'product-categories' ];
    }

    protected function register_controls() {
        $this->register_controls_heading();
        $this->register_remove_heading_element();
        
        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__( 'Product Categories', 'puca' ),
            ]
        );        

        $this->add_control(
            'limit',
            [
                'label' => esc_html__('Number of products', 'puca'),
                'type' => Controls_Manager::NUMBER,
                'description' => esc_html__( 'Number of products to show ( -1 = all )', 'puca' ),
                'default' => 6,
                'min'  => -1,
            ]
        );

        $this->add_control(
            'advanced',
            [
                'label' => esc_html__('Advanced', 'puca'),
                'type' => Controls_Manager::HEADING,
            ]
        );
        $this->register_woocommerce_order();
        $this->add_control(
            'product_type',
            [   
                'label'   => esc_html__('Product Type','puca'),
                'type'     => Controls_Manager::SELECT,
                'options' => $this->get_product_type(),
                'default' => 'newest'
            ]
        );
        $this->register_woocommerce_layout_type();

        $this->add_control(
            'ajax_tabs',
            [
                'label' => esc_html__( 'Ajax Categories Tabs', 'puca' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'description' => esc_html__( 'Show/hidden Ajax Categories Tabs', 'puca' ), 
            ]
        );
    
        $this->add_control(
            'tab_title_center',
            [
                'label'     => esc_html__('Tab Title align Center?', 'puca'),
                'type'      => Controls_Manager::SWITCHER,
                'default' => 'no'
            ]
        );  

        $repeater = $this->register_category_repeater();

        $this->add_control( 
            'categories', 
                [
                'label' => esc_html__( 'Categories', 'puca' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->register_view_all();
        $this->end_controls_section();
        $this->add_control_responsive(['layout_type!' => 'list']);
        $this->add_control_carousel(['layout_type!' =>  array('grid', 'list') ]);
    }

    protected function register_category_repeater() {
        $repeater = new \Elementor\Repeater();

        $categories = $this->get_product_categories();
        $repeater->add_control (
            'category', 
            [
                'label'     => esc_html__('Category', 'puca'),
                'type'      => Controls_Manager::SELECT, 
                'default'   => array_keys($categories)[0],
                'options'   => $categories, 
            ]
        );

        $repeater->add_control(
            'banner_img',
            [
                'label' => esc_html__( 'Choose Image', 'puca' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control (
            'banner_link', 
            [
                'label' => esc_html__('External link','puca'),
                'type' => Controls_Manager::URL,
                'separator'     => 'after',
                'placeholder' => esc_html__( 'https://your-link.com', 'puca' ),
            ]
        );
        
        $repeater->add_control(
            'banner_align',
            [
                'label' => esc_html__('Positions Banner', 'puca'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'puca'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'puca'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => '',
            ]
        );


        return $repeater;
    }


    protected function register_view_all() {
        $this->add_control(
            'show_view_all',
            [
                'label'     => esc_html__('Display View All', 'puca'),
                'type'      => Controls_Manager::SWITCHER,
                'default' => 'no'
            ]
        );  
        $this->add_control(
            'view_all_text',
            [
                'label'     => esc_html__('Text Button', 'puca'),
                'type'      => Controls_Manager::TEXT,
                'default' => esc_html__('View All', 'puca'),
                'condition' => [
                    'show_view_all' => 'yes'
                ]
            ]
        ); 
    }

    public function render_content_banner($banner_img, $banner_link) {

        if( isset($banner_img['id']) && $banner_img['id'] ) { ?>
            <div class="img-banner">
                
                <?php if ( !empty($banner_link['url']) ) : ?>
                    <?php 
                        $this->add_render_attribute('link', 'href', $banner_link['url'] );

                        if( $banner_link['is_external'] === 'on' ) {
                            $this->add_render_attribute('link', 'target', '_blank');
                        }
                        if( $banner_link['nofollow'] === 'on' ) {
                            $this->add_render_attribute('link', 'rel', 'nofollow');
                        }    
                    ?>
                    <a <?php $this->print_render_attribute_string('link'); ?>>
                <?php endif; ?>

                    <?php echo wp_get_attachment_image($banner_img['id'], 'full'); ?>

                <?php if ( !empty($banner_link['url']) ) : ?>
                </a>
                <?php endif; ?>
            </div>
         
        <?php } 
    }
   
    public function render_tabs_title($categories, $random_id) {
        $settings = $this->get_settings_for_display();
        $product_type = $cat_operator  = $limit = $orderby = $order = '';
 
        $rows_default = 1;
        extract($settings);

        if ($ajax_tabs === 'yes') {
            $this->add_render_attribute('row', 'class', ['products']);
            $attr_row = $this->get_render_attribute_string('row'); 

            $rows = ( !empty($rows) ) ? $rows : $rows_default;

            $json = array(
                'product_type'                  => $product_type,
                'cat_operator'                  => $cat_operator,
                'limit'                         => $limit,
                'orderby'                       => $orderby, 
                'order'                         => $order,
                'attr_row'                      => $attr_row, 
                'layout_type'                   => $layout_type,
                'rows'                          => $rows,  
            ); 

            $json = apply_filters( 'puca_ajax_elementor_supermaket_categoriestabs', $json, 10, 1 );

            $encoded_settings  = wp_json_encode( $json );

            $tabs_data = 'data-atts="'. esc_attr( $encoded_settings ) .'"';
        } else {
            $tabs_data = '';
        }
        ?>
        
        <div class="heading-product-category-tabs">
            <?php
                if(!empty($title_cat_tab) || !empty($sub_title_cat_tab) ) {
                    ?>
                    <h3 class="heading-tbay-title">
                        <?php if( !empty($title_cat_tab) ) : ?>
                            <span class="title"><?php echo trim($title_cat_tab); ?></span>
                        <?php endif; ?>	    	
                        <?php if( !empty($sub_title_cat_tab) ) : ?>
                            <span class="subtitle"><?php echo trim($sub_title_cat_tab); ?></span>
                        <?php endif; ?>
                    </h3>
                    <?php
                }
            ?>
            <ul class="product-categories-tabs-title tabs-list nav nav-tabs" <?php echo trim($tabs_data); ?>>
                <?php $_count = 0; ?>
                <?php foreach ( $categories as $item ) : ?>
                    <?php $this->render_product_tab($item, $_count, $random_id); ?>
                    <?php $_count++; ?>
                <?php endforeach; ?>
            </ul>
            
        </div>
        

       <?php
    }

    public function render_product_tab($item, $_count, $random_id) {
        
        ?>
        <?php 
            $active = ($_count == 0) ? 'active' : '';
            $obj_cat = $this->get_category_term($item['category']);

            if ( !is_object($obj_cat) ) return;

            $title = $obj_cat->name;
        ?>   
        <li class="<?php echo esc_attr($active); ?>">
            <a data-value="<?php echo esc_attr($item['category']); ?>" href="#<?php echo esc_attr($item['category'].'-'. $random_id); ?>" data-toggle="tab" aria-controls="<?php echo esc_attr($item['category'].'-'. $random_id); ?>"  data-title="<?php echo esc_attr($title);?>"><?php echo trim($title);?></a>
        </li>

       <?php
    }

    public function render_product_tabs_content($categories, $_id) {
        ?>
            <div class="widget-inner">
                <div class="tbay-addon-content tab-content">
                 <?php 
                 $_count = 0;
                 foreach ($categories as $tab ) {
                    $obj_cat = $this->get_category_term($tab['category']);

                    if( is_object($obj_cat) ) {

                        $tab_active = ($_count == 0) ? ' active active-content current' : '';
                        $this->render_content_tab($tab, $tab_active, $_id, $_count);
                        $_count++;

                     }
                 }
                 ?>
                </div>
            </div>
        <?php
 
    }
    private function  render_content_tab($tab, $tab_active, $_id, $_count) {
        $settings = $this->get_settings_for_display();
        $cat = $banner_img = $banner_link = $banner_align = $cat_operator = $product_type = $limit = $orderby = $order = '';
        $rows = 1;
        extract( $settings );

        $cat            = $tab['category'];
        $banner_img     = $tab['banner_img'];
        $banner_link    = $tab['banner_link'];
        $banner_align   = $tab['banner_align'];
        ?>
        <div class="row tab-pane animated fadeIn <?php echo esc_attr( $tab_active ); ?>" id="<?php echo esc_attr($cat).'-'.$_id; ?>">
        
            <?php if( isset($banner_img['id']) && $banner_img['id'] ) : ?>
                    <?php $banner_positions = (isset($banner_align)) ? $banner_align : 'left'; ?>
                    <div class="pull-<?php echo (isset($banner_positions)) ? esc_attr($banner_positions) : ''; ?> hidden-sm hidden-xs vc_fluid col-md-2 tab-banner">
                        <?php $this->render_content_banner($banner_img, $banner_link); ?>
                    </div>
            <?php endif; ?>

            <?php $content_class = ( isset($banner_img['id']) && $banner_img['id'] ) ? '10' : '12'; ?>
            
            <div class="tab-ajax-content col-md-<?php echo esc_attr($content_class); ?>">

                <?php 
                    if ($_count === 0 || $settings['ajax_tabs'] !== 'yes') {

                        /** Get Query Products with Transient */
                        $transient_name = 'puca_supermaket_product_categories_tab_loop_' . md5($this->get_id()) . '_' . md5($cat) . '_' . md5(serialize($settings));
                        $loop = get_transient($transient_name);

                        if (false === $loop) {
                            /** Get Query Products */
                            $loop = puca_get_query_products($cat,  $cat_operator, $product_type, $limit, $orderby, $order);
                            /** Set Transient */
                            set_transient($transient_name, $loop, DAY_IN_SECONDS);
                        }


                        $attr_row = $this->get_render_attribute_string('row');
                
                        $active_theme = puca_tbay_get_part_theme();

                        wc_get_template( 'layout-products/'. $active_theme .'/'. $layout_type .'.php' , array( 'loop' => $loop, 'attr_row' => $attr_row, 'rows' => $rows) );
                    }
                ?>

            </div>

            <?php $this->render_item_btn_view_all($cat); ?>
        </div>
        <?php
        
    }

    
    public function render_item_btn_view_all($slug) {
        $settings = $this->get_settings_for_display();
        extract( $settings );

        if( $show_view_all !== 'yes' ) return;

        $category = $this->get_category_term($slug);

        $url_category =  get_term_link($category);

        if(isset($view_all_text) && !empty($view_all_text)) {?>
            <a href="<?php echo esc_url($url_category)?>" class="btn btn-block btn-view-all"><?php echo trim($view_all_text) ?><i class="icon-arrow-right icons"></i></a>
            <?php
        }
        
    }

}
$widgets_manager->register(new Puca_Elementor_Supermaket_Categories_Tabs());
