<?php
/**
 * Login form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     9.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( is_user_logged_in() ) {
	return;
}

$class_form = ( $hidden ) ? 'style="display:none;"' : '';
?>

<form class="woocommerce-form woocommerce-form-login login" method="post" <?php echo trim( $class_form );  ?>>

	<?php do_action( 'woocommerce_login_form_start' ); ?>

	<?php 
		$message = ( $message ) ? wpautop( wptexturize( $message ) ) : '';
		echo trim($message); // @codingStandardsIgnoreLine 
	?>

	<p class="form-row">
		<label for="username"><?php esc_html_e( 'Username or email', 'puca' ); ?> <span class="required">*</span>
		<span class="screen-reader-text"><?php esc_html_e( 'Required', 'puca' ); ?></span></label>
		<input type="text" class="input-text" name="username" id="username" autocomplete="username" required aria-required="true" />
	</p>
	<p class="form-row">
		<label for="password"><?php esc_html_e( 'Password', 'puca' ); ?> <span class="required">*</span>
		<span class="screen-reader-text"><?php esc_html_e( 'Required', 'puca' ); ?></span></label>
		<input class="input-text" type="password" name="password" id="password" autocomplete="current-password" required aria-required="true" />
	</p>
	<div class="clear"></div>

	<?php do_action( 'woocommerce_login_form' ); ?>

	<p class="form-row last">

		<input type="submit" class="button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="login" value="<?php esc_attr_e( 'Login', 'puca' ); ?>" />
		<input type="hidden" name="redirect" value="<?php echo esc_url( $redirect ) ?>" />
		<label class="woocommerce-form__label woocommerce-form__label-for-checkbox inline">
			<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <span><?php esc_html_e( 'Remember me', 'puca' ); ?></span>
		</label>
		<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
		<p class="lost_password">
			<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'puca' ); ?></a>
		</p>
	</p>

	<div class="clear"></div>

	<?php do_action( 'woocommerce_login_form_end' ); ?>

</form>
