<?php

/* translators: %s: Quantity. */
$label = !empty($args['product_name']) ? sprintf(esc_html__('%s quantity', 'puca'), wp_strip_all_tags($args['product_name'])) : esc_html__('Quantity', 'puca');

?>
<div class="quantity <?php echo esc_attr($type); ?>">
	<?php
    /**
     * Hook to output something before the quantity input field.
     *
     * @since 7.2.0
     */
    do_action('woocommerce_before_quantity_input_field');
    ?>
	<label class="screen-reader-text" for="<?php echo esc_attr($input_id); ?>"><?php echo esc_html($label); ?></label>
	<button class="minus" type="button" value="&#160;"><span class="icons icon-arrow-left"></span></button>
	<input 
		type="<?php echo esc_attr($type); ?>"
		<?php echo esc_attr($readonly ? 'readonly="readonly"' : ''); ?>
		id="<?php echo esc_attr($input_id); ?>"
		class="<?php echo esc_attr(join(' ', (array) $classes)); ?>"
		min="<?php echo esc_attr($min_value); ?>" 
		<?php if ( 0 < $max_value ) : ?>
			max="<?php echo esc_attr( $max_value ); ?>"
		<?php endif; ?>
		name="<?php echo esc_attr($input_name); ?>" 
		value="<?php echo esc_attr($input_value); ?>" 
		aria-label="<?php esc_attr_e( 'Product quantity', 'puca' ); ?>"
		<?php if ( in_array( $type, array( 'text', 'search', 'tel', 'url', 'email', 'password' ), true ) ) : ?>
			size="4"
		<?php endif; ?>
		<?php if (!$readonly): ?>
			step="<?php echo esc_attr($step); ?>" 
			placeholder="<?php echo esc_attr($placeholder); ?>"
			inputmode="<?php echo esc_attr($inputmode); ?>" 
			autocomplete="<?php echo esc_attr(isset($autocomplete) ? $autocomplete : 'on'); ?>"
		<?php endif; ?>
	/>
	<button class="plus" type="button" value="&#160;"><span class="icons icon-arrow-right"></span></button>
	<?php
    /**
     * Hook to output something after quantity input field.
     *
     * @since 3.6.0
     */
    do_action('woocommerce_after_quantity_input_field');
    ?>
</div>