<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 7.8.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$images_layout      = 'horizontal';
$is_rtl 			= (is_rtl()) ? 'yes' : 'no';

global $post, $product;

//check Enough number image thumbnail
$attachment_ids = $product->get_gallery_image_ids();
$count = 0;
foreach( $attachment_ids as $attachment_id ) 
{
    $count ++;
}
$columns = puca_tbay_get_config('number_product_thumbnail', 3);

$class_thumbnail = '';
if( empty($attachment_ids) ) {
	$class_thumbnail = 'no-gallery-image';
}

$thumbnail_size    = apply_filters( 'woocommerce_product_thumbnails_large_size', 'full' );
$post_thumbnail_id = $product->get_image_id();
$full_size_image   = wp_get_attachment_image_src( $post_thumbnail_id, $thumbnail_size );
$placeholder       = has_post_thumbnail() ? 'with-images' : 'without-images';
$wrapper_classes   = apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
	'woocommerce-product-gallery',
	'horizontal-top',
	'woocommerce-product-gallery--' . $placeholder,
	'woocommerce-product-gallery--columns-' . absint( $columns ),
	'images',
	$class_thumbnail, 
) );

?>
<div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>" data-rtl="<?php echo esc_attr($is_rtl); ?>" data-layout="<?php echo esc_attr($images_layout); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">

	<?php do_action( 'tbay_product_video' ); ?>

	<div class="woocommerce-product-gallery__wrapper">
		<?php

		if ( is_singular('product') && $post_thumbnail_id ) {
			$attributes = array(
				'title'                   => get_post_field( 'post_title', $post_thumbnail_id ),
				'data-caption'            => get_post_field( 'post_excerpt', $post_thumbnail_id ),
				'data-src'                => $full_size_image[0],
				'data-large_image'        => $full_size_image[0],
				'data-large_image_width'  => $full_size_image[1],
				'data-large_image_height' => $full_size_image[2],
			);
		}


		if ( is_singular('product') ) {

			if ( $post_thumbnail_id ) {
				$html = wc_get_gallery_image_html( $post_thumbnail_id, true );
			} else {
	            $wrapper_classname = $product->is_type( 'variable' ) && ! empty( $product->get_available_variations( 'image' ) ) ?
	            'woocommerce-product-gallery__image woocommerce-product-gallery__image--placeholder' :
	            'woocommerce-product-gallery__image--placeholder';
	            $html  = sprintf( '<div class="%s">', esc_attr( $wrapper_classname ) );
				$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'puca' ) );
				$html .= '</div>';
			}

			
			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id );

			
			do_action( 'woocommerce_product_thumbnails' );

		}
		else {

			if ( $post_thumbnail_id ) {
				$html = wc_get_gallery_image_html( $post_thumbnail_id, true );
			} else {
	            $wrapper_classname = $product->is_type( 'variable' ) && ! empty( $product->get_available_variations( 'image' ) ) ?
	            'woocommerce-product-gallery__image woocommerce-product-gallery__image--placeholder' :
	            'woocommerce-product-gallery__image--placeholder';
	            $html  = sprintf( '<div class="%s">', esc_attr( $wrapper_classname ) );
				$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'puca' ) );
				$html .= '</div>';
			}


			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id );

			do_action( 'woocommerce_product_thumbnails' );

		}
		?>
	</div>
	<?php 
		do_action( 'puca_woocommerce_after_product_thumbnails' );
	?>
</div>
