<?php
if (! function_exists('puca_clear_footer_layouts_transient')) {
    function puca_clear_footer_layouts_transient($post_id) {
        delete_transient('puca_footer_layouts_elementor');

        $footer                 = get_post_field('post_name', $post_id);
        $transient_name 		= 'puca_footer_builder_loop_' . md5($footer);
        delete_transient($transient_name);
    }
    add_action('save_post_tbay_footer', 'puca_clear_footer_layouts_transient');
    add_action('delete_post_tbay_footer', 'puca_clear_footer_layouts_transient');
    add_action('edit_post_tbay_footer', 'puca_clear_footer_layouts_transient');
}

if (! function_exists('puca_clear_megamenu_cache')) {
    function puca_clear_megamenu_cache($post_id) {
        set_transient('puca_megamenu_cache_clear', true, 60);
    }
    add_action('save_post_tbay_megamenu', 'puca_clear_megamenu_cache');
    add_action('delete_post_tbay_megamenu', 'puca_clear_megamenu_cache');
    add_action('wp_trash_post_tbay_megamenu', 'puca_clear_megamenu_cache');
}

if ( ! function_exists( 'puca_clear_available_pages_transient' ) ) {
    function puca_clear_available_pages_transient($post_id) {
        delete_transient('puca_available_pages');
    }
    add_action('save_post_page', 'puca_clear_available_pages_transient');
    add_action('delete_post_page', 'puca_clear_available_pages_transient');
}

if (! function_exists('puca_clear_available_menus_transient')) {
    function puca_clear_available_menus_transient() {
        delete_transient('puca_available_menus');
        global $sitepress;
        $current_lang = apply_filters('wpml_current_language', null);
        delete_transient('puca_menus_wpml_' . $current_lang);
    }
    // Hook into menu creation
    add_action('wp_create_nav_menu', 'puca_clear_available_menus_transient');
    // Hook into menu deletion
    add_action('wp_delete_nav_menu', 'puca_clear_available_menus_transient');
}

if (! function_exists('puca_clear_product_categories_transient')) {
    // Function to delete transients for product categories
    function puca_clear_product_categories_transient($term_id, $tt_id, $taxonomy) {
        delete_transient('puca_product_categories_all');
    }
    add_action('created_product_cat', 'puca_clear_product_categories_transient', 10, 3);
    add_action('edited_product_cat', 'puca_clear_product_categories_transient', 10, 3);
    add_action('delete_product_cat', 'puca_clear_product_categories_transient', 10, 2);
}

if (!function_exists('puca_clear_woocommerce_tags_transient')) {
    function puca_clear_woocommerce_tags_transient($term_id) {
        $transient_name = 'puca_woocommerce_tags';
        delete_transient($transient_name);
    }
    add_action('created_product_tag', 'puca_clear_woocommerce_tags_transient', 10, 1);
    add_action('delete_product_tag', 'puca_clear_woocommerce_tags_transient', 10, 1);
    add_action('edited_product_tag', 'puca_clear_woocommerce_tags_transient', 10, 1);
}

if (!function_exists('puca_clear_all_product_transients')) {
    add_action('woocommerce_product_set_stock', 'puca_clear_all_product_transients');
    add_action('woocommerce_update_product_sale_price', 'puca_clear_all_product_transients');
    add_action('save_post_product', 'puca_clear_all_product_transients');
    add_action('delete_post_product', 'puca_clear_all_product_transients');
    add_action('edit_post_product', 'puca_clear_all_product_transients');
    function puca_clear_all_product_transients( $post_id ) {
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
        }
        if ( get_post_type( $post_id ) !== 'product' ) {
            return;
        }

        global $wpdb;
        
        $prefixes = array(
            'puca_product_category_loop_',
            'puca_products_loop_',
            'puca_supermaket_products_loop_',
            'puca_supermaket2_product_categories_tab_loop_',
            'puca_product_flash_sale_loop_',
            'puca_product_categories_tab_loop_',
            'puca_supermaket_product_categories_tab_loop_',
            'puca_product_count_down_loop_',
            'puca_product_tabs_loop_',
        );
        
        foreach ( $prefixes as $prefix ) {
            $wpdb->query( 
                $wpdb->prepare( 
                    "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s", 
                    '_transient_' . $prefix . '%' 
                ) 
            );
            $wpdb->query( 
                $wpdb->prepare( 
                    "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s", 
                    '_transient_timeout_' . $prefix . '%' 
                ) 
            );
        }

        delete_transient('puca_on_sale_products');
        delete_transient('puca_woocommerce_tags');
        delete_transient('puca_products_countdown');
        delete_transient('puca_product_categories_all');
    }
}

if (!function_exists('puca_clear_tbay_brand_transients')) {
    function puca_clear_tbay_brand_transients() {
        $transient_name = 'puca_tbay_brands_elementor';
        delete_transient($transient_name);
    }
    add_action('save_post_tbay_brand', 'puca_clear_tbay_brand_transients');
    add_action('delete_post_tbay_brand', 'puca_clear_tbay_brand_transients');
    add_action('edit_post_tbay_brand', 'puca_clear_tbay_brand_transients');
}

if (!function_exists('puca_clear_tbay_testimonial_transients')) {
    function puca_clear_tbay_testimonial_transients() {
        $transient_name = 'puca_tbay_testimonials_elementor';
        delete_transient($transient_name);
    }
    add_action('save_post_tbay_testimonial', 'puca_clear_tbay_testimonial_transients');
    add_action('delete_post_tbay_testimonial', 'puca_clear_tbay_testimonial_transients');
    add_action('edit_post_tbay_testimonial', 'puca_clear_tbay_testimonial_transients');
}