'use strict';

class StickyHeader {
  constructor() {
    this.$tbayHeader = jQuery('#tbay-header');
    this.$isExistedEventMiniCartClick = false;

    if (this.$tbayHeader.hasClass('main-sticky-header')) {
      this._initStickyHeader();
    }

    this._widgetProducts();

    jQuery(".search-horizontal .btn-search-totop").on("click", function () {
      jQuery(".container-search-horizontal").toggleClass('active').find(".tbay-search").focus();
    });

    this._clickHorizontalSearch();
  }

  _initStickyHeader() {
    var _this = this;

    var tbay_width = jQuery(window).width();

    var header_height = this._getHeaderHeight();

    jQuery(window).scroll(function () {
      jQuery('#tbay-top-cart').height() > 0 ? jQuery('#tbay-top-cart.tbay-top-cart.v1').height() : 0;

      if (tbay_width >= 1024) {
        if (jQuery(this).scrollTop() > header_height) {
          if (_this.$tbayHeader.hasClass('sticky-header1')) return;

          _this._stickyHeaderOnDesktop(header_height);
        } else {
          _this.$tbayHeader.next().css('margin-top', 0);

          _this.$tbayHeader.css("top", 0).removeClass('sticky-header1');

          jQuery("#tbay-header.header-v8 .search-full").slideToggle(500);
        }
      }

      if (tbay_width <= 767) {
        _this._fixedHeaderOnMobile();
      }
    });
  }

  _fixedHeaderOnMobile() {
    if (jQuery('body').hasClass('post-type-archive-product')) {
      var NextScroll = jQuery('.archive-shop .tbay-filter + .products').offset().top - jQuery(window).scrollTop();

      if (NextScroll < 99) {
        jQuery('.archive-shop .tbay-filter').next().css('margin-top', jQuery('.archive-shop .tbay-filter').height() + 20);
        jQuery('.archive-shop .tbay-filter').addClass('fixed').css("top", 36 + jQuery('#wpadminbar').outerHeight());
      } else {
        jQuery('.archive-shop .tbay-filter').css("top", 0);
        jQuery('.archive-shop .tbay-filter').removeClass('fixed');
        jQuery('.archive-shop .tbay-filter').next().css('margin-top', 0);
      }
    }
  }

  _stickyHeaderOnDesktop(header_height) {
    if (this.$tbayHeader.hasClass('sticky-header1')) {
      return;
    }

    this.$tbayHeader.addClass('sticky-header1').css("top", jQuery('#wpadminbar').outerHeight());
    jQuery("#tbay-top-cart").slideUp(500, function () {});
    jQuery("#tbay-header.header-v8 .search-full").slideUp(500, function () {});
    this.$tbayHeader.next().css('margin-top', header_height);

    if (this.$isExistedEventMiniCartClick) {
      return;
    }

    jQuery('#tbay-header.sticky-header1 .tbay-topcart a.mini-cart.v1').on('click', () => {
      this.$isExistedEventMiniCartClick = true;
      jQuery('html, body').scrollTop(0);
    });
  }

  _getHeaderHeight() {
    var header_height = this.$tbayHeader.height();
    return header_height;
  }

  _widgetProducts() {
    if (jQuery(".widget-products").hasClass("carousel-blur")) {
      jQuery('.widget-products.carousel-blur').parents('.vc_row[data-vc-full-width="true"]').addClass('tbay-product-carousel-blur');
      jQuery('.widget-products.carousel-blur').parents('.elementor-section-stretched.elementor-section-full_width').addClass('elementor-product-carousel-blur');
    }

    if (jQuery(".widget-products").hasClass("special-home5")) {
      jQuery('.widget-products.special-home5').parents('.vc_row[data-vc-full-width="true"]').addClass('tbay-product-special-home5');
      jQuery('.widget-products.special-home5').parents('.elementor-section-stretched.elementor-section-full_width').addClass('elementor-product-special-home5');
    }
  }

  _clickHorizontalSearch() {
    var $box_search = jQuery('.search-horizontal .btn-search-totop, .container-search-horizontal,.ui-autocomplete.ui-widget-content.style1.horizontal');
    jQuery(window).on("click.Bst", function (event) {
      if ($box_search.has(event.target).length == 0 && !$box_search.is(event.target)) {
        jQuery(".container-search-horizontal").removeClass('active');
      }
    });
  }

}

class AutoComplete {
  constructor() {
    if (typeof puca_settings === "undefined") return;

    var _this = this;

    _this._callAjaxSearch();

    jQuery(document.body).on('search_device_mobile', event => {
      _this._callAjaxSearch();
    });
  }

  _callAjaxSearch() {
    var acs_action = 'puca_autocomplete_search',
        _this = this,
        jQuerytop = this._getTop(),
        $t = jQuery("input[name=s]");

    $t.on("focus", function () {
      var _this2 = jQuery(this);

      if (!jQuery(this).parents('.tbay-search-form').hasClass('tbay-search-ajax')) return;
      var appendto = typeof jQuery(this).parents('form').data('appendto') !== "undefined" ? jQuery(this).parents('form').data('appendto') : '';
      jQuery(this).autocomplete({
        source: function (req, response) {
          jQuery.ajax({
            url: puca_settings.ajaxurl + '?callback=?&action=' + acs_action,
            dataType: "json",
            data: {
              term: req.term,
              category: this.element.parent().find('.dropdown_product_cat').val(),
              style: this.element.data('style'),
              nonce: puca_settings.nonce,
              post_type: this.element.parent().find('.post_type').val()
            },
            success: function (data, event, ui) {
              if (!data.length) {
                if (_this2.val().length > 1) {
                  if (_this2.parents('form').find(appendto).find('ul').length > 0) {
                    _this2.parents('form').find(appendto).find('ul li').remove();
                  } else {
                    jQuery('.ui-autocomplete.' + _this2.data('style')).find('li').remove();
                  }
                }
              }

              response(data);
            }
          });
        },
        position: {
          my: 'left+0 top+' + jQuerytop + ''
        },
        minLength: 2,
        appendTo: appendto,
        search: function (event) {
          jQuery(event.currentTarget).parents('.tbay-search-form').addClass('load');
        },
        select: function (event, ui) {
          window.location.href = ui.item.link;
        },
        create: function () {
          jQuery(this).data('ui-autocomplete')._renderItem = function (ul, item) {
            var string = '';
            ul.addClass('ui-autocomplete-search');
            ul.addClass(item.style);

            if (item.image && item.image.length > 0) {
              var string = '<a href="' + item.link + '" title="' + item.label + '"><img src="' + item.image + '" ></a>';
            }

            string += '<div class="group">';
            string += '<div class="name"><a href="' + item.link + '" title="' + item.label + '">' + item.label + '</a></div>';

            if (item.sku && item.sku.length > 0) {
              string += '<div class="product-sku">' + item.sku + '</div>';
            }

            if (item.price && item.price.length > 0) {
              string += '<div class="price">' + item.price + '</div>';
            }

            string += '</div>';
            var strings = jQuery("<li>").append(string).appendTo(ul);
            return strings;
          };

          jQuery(this).data('ui-autocomplete')._renderMenu = function (ul, items) {
            var that = this;
            jQuery.each(items, function (index, item) {
              that._renderItemData(ul, item);
            });

            if (typeof _this2.data('style') !== "undefined" && _this2.data('style') != 'search-min') {
              if (items[0].view_all) {
                ul.append('<li class="list-header ui-menu-divider">' + items[0].result + '<a id="search-view-all" data-id="#' + this.element.parents('form').attr('id') + '" href="javascript:void(0)">' + puca_settings.view_all + '</a></li>');
              } else {
                ul.append('<li class="list-header ui-menu-divider">' + items[0].result + '</li>');
              }
            } else {
              if (items[0].view_all) {
                ul.append('<li class="list-header ui-menu-divider">' + items[0].result + '</li>');
                ul.append('<li class="list-bottom ui-menu-divider"><a id="search-view-all" data-id="#' + this.element.parents('form').attr('id') + '" href="javascript:void(0)">' + puca_settings.view_all + '</a></li>');
              } else {
                ul.append('<li class="list-header ui-menu-divider">' + items[0].result + '</li>');
              }
            }

            jQuery(document.body).trigger('puca_search_view_all');
          };
        },
        response: (event, ui) => {
          _this._autoCompeleteResponse(ui.content.length);
        },
        open: (event, ui) => {
          jQuery(event.target).parents('.tbay-search-form').removeClass('load');
          jQuery(event.target).parents('.tbay-search-form').addClass('active');
          var width_ul = jQuery(event.target).parents('form').outerWidth();
          var left = jQuery(event.target).parents('form').offset().left;
          jQuery(event.target).autocomplete("widget").css({
            "width": width_ul,
            "left": left
          });
        },
        close: event => {
          _this._autoCompeleteClose(event);
        }
      }).focus(function () {
        if (_this2.val().length > 1) {
          if (_this2.parents('form').find(appendto).find('ul').length > 0) {
            _this2.parents('form').find(appendto).find('ul').show();
          } else {
            jQuery('.ui-autocomplete.' + _this2.data('style')).show();
          }

          _this2.trigger(jQuery.Event("keydown"));
        }
      });
    });
    jQuery('.tbay-preloader').on("click", function () {
      _this._onClickTbayPreloader(event);
    });
    jQuery(document.body).on('puca_search_view_all', () => {
      jQuery('#search-view-all').on('click', function () {
        jQuery(jQuery(this).data('id')).submit();
      });
    });
  }

  _getTop() {
    let jQuerytop = 0;

    switch (jQuery("input[name=s]:visible").data('style')) {
      case 'style1 home5':
        jQuerytop = -47;
        break;

      case 'style1 home6':
        jQuerytop = 20;
        break;

      case 'style1':
        jQuerytop = 24;
        break;

      case 'style1 home5 home8':
        jQuerytop = -45;
        break;
    }

    return jQuerytop;
  }

  _onClickTbayPreloader(event) {
    jQuery(event.currentTarget).parents('.tbay-search-form').removeClass('active');
    jQuery(event.currentTarget).parents('.tbay-search-form').find('input[name=s]').val('');
    jQuery(event.currentTarget).parents('.tbay-search-form').find('input[name=s]').autocomplete('destroy');

    if (jQuery(event.currentTarget).hasClass('no-results')) {
      jQuery(event.currentTarget).removeClass('no-results').empty();
    }
  }

  _autoCompeleteResponse(length) {
    let preloader = jQuery(".tbay-preloader");

    if (length === 0) {
      preloader.text(puca_settings.no_results);
      preloader.addClass('no-results');
      preloader.parents('.tbay-search-form').removeClass('load');
      preloader.parents('.tbay-search-form').addClass('active');
    } else {
      preloader.empty();
      preloader.removeClass('no-results');
    }
  }

  _autoCompeleteClose(event) {
    jQuery(event.target).parents('.tbay-search-form').removeClass('load');
  }

}

jQuery(document).ready(() => {
  new StickyHeader();
  new AutoComplete();
});
