<?php 
global $product;

?>

   <div class="product-block grid v3" data-product-id="<?php echo esc_attr($product->get_id()); ?>">
        <?php do_action( 'puca_content_product_item_before' ); ?>
        <div class="product-content">
            <div class="block-inner">
                <figure class="image">
                    <a title="<?php the_title_attribute(); ?>" href="<?php echo the_permalink(); ?>" class="product-image">
                        <?php
                            /**
                            * woocommerce_before_shop_loop_item_title hook
                            *
                            * @hooked woocommerce_show_product_loop_sale_flash - 10
                            * @hooked woocommerce_template_loop_product_thumbnail - 10
                            */
                            do_action( 'woocommerce_before_shop_loop_item_title' );
                        ?>
                    </a>

                    <?php 
                        do_action( 'woocommerce_before_shop_loop_item_title_2' );
                    ?>

                    <div class="group-buttons clearfix">    
                                           
                        <?php if (class_exists('YITH_WCQV_Frontend')) { ?>
                            <?php 
                                wp_enqueue_script( 'slick' );
                                wp_enqueue_script( 'puca-custom-slick' );	
                            ?>
                            <div>
                                <a href="#" class="button yith-wcqv-button" title="<?php echo esc_attr__('Quick view', 'puca'); ?>"  data-product_id="<?php echo esc_attr($product->get_id()); ?>">
                                    <i class="icon-eye icons"></i>
                                    <span><?php echo esc_html__('Quick view', 'puca'); ?></span>
                                </a>
                            </div>  
                        <?php } ?>
                        <?php if( class_exists( 'YITH_Woocompare' ) ) { ?>
                            <div class="yith-compare">
                                <?php do_action('puca_before_add_to_compare_button'); ?>
                            </div>
                        <?php } ?> 
                        
                        <?php if( class_exists( 'YITH_WCWL' ) ) { ?>
                            <?php 
                                $enabled_on_loop = 'yes' == get_option( 'yith_wcwl_show_on_loop', 'no' ); 
                                if( !$enabled_on_loop ) { ?>
                                <div class="button-wishlist">
                                    <?php
                                        echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
                                    ?>  
                                </div>
                            <?php } ?> 

                        <?php } ?> 

                        
                    </div>
                </figure>
            </div>
            
            <div class="caption">

                <h3 class="name"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>

                <?php
                    /**
                    * woocommerce_after_shop_loop_item_title hook
                    *
                    * @hooked woocommerce_template_loop_rating - 5
                    * @hooked woocommerce_template_loop_price - 10
                    */
                    remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);
                    add_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 15);
                    do_action( 'woocommerce_after_shop_loop_item_title');
                ?>
                
                <?php 
                    /**
                    * puca_woocommerce_time_countdown hook
                    *
                    * @hooked puca_woo_product_time_countdown - 10
                    */
                    do_action('puca_woocommerce_time_countdown');
                ?>
                <div class="woocommerce-product-details__short-description">
                    <?php echo  the_excerpt();  ?>
                </div>
                <div class="group-image">
                    <?php do_action( 'woocommerce_after_shop_loop_item' ); ?>
                    <?php do_action( 'puca_loop_item_quantity' ); ?>
                </div>    
            </div>

        </div>
        
    </div>
        
