<?php 
global $product;

wp_enqueue_script( 'wc-flexslider' ); 

?>
   <div class="product-block grid style-horizontal clearfix" data-product-id="<?php echo esc_attr($product->get_id()); ?>">
        <?php do_action( 'puca_content_product_item_before' ); ?>
        <div class="block-inner">
            <figure class="image image-mains">
			     
                <?php
                    /**
                     * woocommerce_before_single_product_summary hook.
                     *
                     * @hooked woocommerce_show_product_sale_flash - 10
                     * @hooked woocommerce_show_product_images - 20
                     */
                    remove_action('woocommerce_before_single_product_summary','woocommerce_show_product_sale_flash', 10);
                    do_action( 'woocommerce_before_single_product_summary' );
                ?>

            </figure>

            <?php 
                /**
                * puca_woocommerce_time_countdown hook
                *
                * @hooked puca_woo_product_time_countdown - 10
                */
                remove_action('puca_woocommerce_time_countdown','puca_supermaket_add_product_description', 15);
                do_action('puca_woocommerce_time_countdown'); 
                add_action('puca_woocommerce_time_countdown','puca_supermaket_add_product_description', 15);
            ?>

        </div>
        <div class="caption">
            <h3 class="name"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
            <?php
                /**
                * woocommerce_after_shop_loop_item_title hook
                *
                * @hooked woocommerce_template_loop_rating - 5
                * @hooked woocommerce_template_loop_price - 10
                */
                do_action( 'woocommerce_after_shop_loop_item_title');

            ?>
            <div class="groups-button">
                <?php do_action( 'woocommerce_after_shop_loop_item' ); ?>

                <div class="groups-button-image clearfix">  

                <?php if( class_exists( 'YITH_WCWL' ) ) { ?>
                    <?php 
                        $enabled_on_loop = 'yes' == get_option( 'yith_wcwl_show_on_loop', 'no' ); 
                        if( !$enabled_on_loop ) { ?>
                        <div class="button-wishlist">
                            <?php
                                echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
                            ?>  
                        </div>
                    <?php } ?> 

                <?php } ?> 


                <?php if (class_exists('YITH_WCQV_Frontend')) { ?>
                    <?php 
                        wp_enqueue_script( 'slick' );
                        wp_enqueue_script( 'puca-custom-slick' );	
                    ?>
                    <div>
                        <a href="#" class="button yith-wcqv-button" title="<?php esc_attr_e('Quick view', 'puca'); ?>"  data-product_id="<?php echo esc_attr($product->get_id()); ?>">
                            <span>
                                <i class="icon-eye icons"></i>
                            </span>
                        </a>
                    </div>  
                <?php } ?>

                <?php if( class_exists( 'YITH_Woocompare' ) ) { ?>
                    <div class="yith-compare">
                        <?php do_action('puca_before_add_to_compare_button'); ?>
                    </div>
                <?php } ?> 
                </div>
            </div>    
        </div>
    </div> 
