<?php 
global $product;


?>
<div class="product-block list" data-product-id="<?php echo esc_attr($product->get_id()); ?>">
	<?php do_action( 'puca_content_product_item_before' ); ?>
	<div class="row product-content">
		<div class="col-sm-5 list-img">
		    <figure class="image">
		        <a title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>" class="product-image">
		            <?php
		                /**
		                * woocommerce_before_shop_loop_item_title hook
		                *
		                * @hooked woocommerce_show_product_loop_sale_flash - 10
		                * @hooked woocommerce_template_loop_product_thumbnail - 10
		                */
		                do_action( 'woocommerce_before_shop_loop_item_title' );
		            ?>
		        </a>
				
				
		    </figure>
		    <?php (class_exists( 'YITH_WCBR' )) ? puca_brands_get_name($product->get_id()) : ''; ?>
		</div>    
	    <div class="col-sm-7 list-content">
	    	<?php 
				do_action( 'puca_woocommerce_before_shop_loop_item_caption' );
			?>
		    <div class="caption-list">
		        <h3 class="name"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
	            <?php
	                /**
	                * woocommerce_after_shop_loop_item_title hook
	                *
	                * @hooked woocommerce_template_loop_rating - 5
	                * @hooked woocommerce_template_loop_price - 10
	                */
	                add_action('woocommerce_after_shop_loop_item_title','woocommerce_show_product_loop_sale_flash', 15);
					do_action( 'woocommerce_after_shop_loop_item_title');
					do_action( 'puca_woocommerce_after_shop_loop_item_caption' );
					do_action( 'woocommerce_before_shop_loop_item_title_2' );

	            ?>
				
					
	            <div class="woocommerce-product-details__short-description">
	           		<?php echo  the_excerpt();  ?>
	           	</div>	
        		<div class="groups-button">
                    <?php do_action( 'woocommerce_after_shop_loop_item' ); ?>
                    <?php do_action( 'puca_loop_item_quantity' ); ?>

					<?php if( class_exists( 'YITH_WCWL' ) ) { ?>
						<?php 
							$enabled_on_loop = 'yes' == get_option( 'yith_wcwl_show_on_loop', 'no' ); 
							if( !$enabled_on_loop ) { ?>
							<div class="button-wishlist">
								<?php
									echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
								?>  
							</div>
						<?php } ?> 

					<?php } ?> 


					<?php if (class_exists('YITH_WCQV_Frontend')) { ?>
						<?php 
							wp_enqueue_script( 'slick' );
							wp_enqueue_script( 'puca-custom-slick' );	
						?>
					<div>
						<a href="#" class="button yith-wcqv-button" title="<?php esc_attr_e('Quick view', 'puca'); ?>"  data-product_id="<?php echo esc_attr($product->get_id()); ?>">
							<span>
								<i class="icon-eye icons"></i>
							</span>
						</a>
					</div>	
					<?php } ?>

					<?php if( class_exists( 'YITH_Woocompare' ) ) { ?>
						<div class="yith-compare">
							<?php do_action('puca_before_add_to_compare_button'); ?>
						</div>
					<?php } ?> 
			            
                </div>
		    </div>

		</div>    
	</div>	    
</div>
