<?php 
global $product;


?>
<div class="product-block list" data-product-id="<?php echo esc_attr($product->get_id()); ?>">
	<?php do_action( 'puca_content_product_item_before' ); ?>
	<div class="row">
		<div class="col-sm-5 col-md-5 list-img">
		    <figure class="image">
		        <?php woocommerce_show_product_loop_sale_flash(); ?>
		        <a title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>" class="product-image">
		            <?php
		                /**
		                * woocommerce_before_shop_loop_item_title hook
		                *
		                * @hooked woocommerce_show_product_loop_sale_flash - 10
		                * @hooked woocommerce_template_loop_product_thumbnail - 10
		                */
		                do_action( 'woocommerce_before_shop_loop_item_title' );
		            ?>
		        </a>
	
		    </figure>
		</div>    
	    <div class="col-sm-7 col-md-7 list-content">
	    	<?php 
				do_action( 'puca_woocommerce_before_shop_loop_item_caption' );
			?>
		    <div class="caption-list">
		        
		        <div class="meta">

		         <h3 class="name"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
		            <?php
		                /**
		                * woocommerce_after_shop_loop_item_title hook
		                *
		                * @hooked woocommerce_template_loop_rating - 5
		                * @hooked woocommerce_template_loop_price - 10
		                */
		                do_action( 'woocommerce_after_shop_loop_item_title');
						do_action( 'puca_woocommerce_after_shop_loop_item_caption' );
						do_action( 'woocommerce_before_shop_loop_item_title_2' );
		            ?>
		            <?php echo  the_excerpt();  ?>
            		<div class="groups-button">
                        <?php do_action( 'woocommerce_after_shop_loop_item' ); ?>
                        <?php do_action( 'puca_loop_item_quantity' ); ?>
              
		                <?php
			                $enabled_on_loop = 'yes' == get_option( 'yith_wcwl_show_on_loop', 'no' );
							if( class_exists( 'YITH_WCWL' ) || $enabled_on_loop ) {
			                    echo do_shortcode( '[yith_wcwl_add_to_wishlist]' );
			                }
			            ?>   
			    
						<?php if( class_exists( 'YITH_Woocompare' ) ) { ?>
							<div class="yith-compare">
								<?php do_action('puca_before_add_to_compare_button'); ?>
							</div>
						<?php } ?> 
				        <?php if (class_exists('YITH_WCQV_Frontend')) { ?>
							<?php 
								wp_enqueue_script( 'slick' );
								wp_enqueue_script( 'puca-custom-slick' );	
							?>
							<a href="#" class="button yith-wcqv-button" title="<?php esc_attr_e('Quick view', 'puca'); ?>"  data-product_id="<?php echo esc_attr($product->get_id()); ?>">
								<i class="icon-eye icons"> </i>
							</a>
						<?php } ?>	
                    </div>

		        </div>    
		        
		    </div>

		</div>    
	</div>	    
</div>
