<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 7.8.0
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $post, $product; 

$sidebar_configs    = puca_tbay_get_woocommerce_layout_configs();
$images_layout      = ( !empty( $sidebar_configs['thumbnail'] ) ) ? $sidebar_configs['thumbnail'] : 'horizontal';
$is_rtl 			= (is_rtl()) ? 'yes' : 'no';

//check Enough number image thumbnail
$attachment_ids = $product->get_gallery_image_ids();
$count = 0;
foreach( $attachment_ids as $attachment_id ) 
{
    $count ++;
}
$columns = puca_tbay_get_config('number_product_thumbnail', 3);

$thumbnail_size    = apply_filters( 'woocommerce_product_thumbnails_large_size', 'full' );
$post_thumbnail_id = $product->get_image_id();
$full_size_image   = wp_get_attachment_image_src( $post_thumbnail_id, $thumbnail_size );
$placeholder       = has_post_thumbnail() ? 'with-images' : 'without-images';
$wrapper_classes   = apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
	'woocommerce-product-gallery-quick-view',
	'woocommerce-product-gallery--' . $placeholder,
	'woocommerce-product-gallery--columns-' . absint( $columns ),
	'images',
) );
?>
<div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>" data-rtl="<?php echo esc_attr($is_rtl); ?>" data-layout="<?php echo esc_attr($images_layout); ?>"  style="opacity: 0; transition: opacity .25s ease-in-out;">

	<?php do_action( 'tbay_product_video' ); ?>

	<div class="woocommerce-product-gallery__wrapper">
		<?php
			if ( $product->get_image_id() ) {
				$html = wc_get_gallery_image_html( $post_thumbnail_id, true );
			} else {
				$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
				$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_html__( 'Awaiting product image', 'puca' ) );
				$html .= '</div>';
			}

			
			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id );

			
			do_action( 'puca_woocommerce_product_thumbnails' );
		?>
	</div>
	<?php 
		do_action( 'puca_woocommerce_after_product_thumbnails' );
	?>
</div>
