<?php
add_action( 'tgmpa_register', 'reobiz_register_required_plugins' );
function reobiz_register_required_plugins() {
	$plugins = [
		[
			'name'     => 'Redux Framework',
			'slug'     => 'redux-framework',
			'required' => true,
		],

		[
			'name'     => 'Elementor',
			'slug'     => 'elementor',
			'required' => true,
		],
		[
			'name'     => 'Breadcrumb NavXT',
			'slug'     => 'breadcrumb-navxt',
			'required' => true,
		],

		[
			'name'     => 'Contact Form 7',
			'slug'     => 'contact-form-7',
			'required' => true,
		],

		[
			'name'     => 'Mailchimp for WordPress',
			'slug'     => 'mailchimp-for-wp',
			'required' => true,
		],

		[
			'name'     => 'Ultimate Coming Soon',
			'slug'     => 'ultimate-coming-soon',
			'required' => true,
		],

		[
			'name'     => 'One Click Demo Import',
			'slug'     => 'one-click-demo-import',
			'required' => true,
		],
		[
			'name'     => 'WooCommerce',
			'slug'     => 'woocommerce',
			'required' => true,
		],
		[
			'name'               => 'RSElements',
			'slug'               => 'rselements',
			'source'             => 'https://www.rstheme.com/products/demo-data/reobiz/plugins/rselements.zip',
			'required'           => true,
			'version'            => '3.0.1',
			'force_activation'   => false,
			'force_deactivation' => false,
			'external_url'       => '',
			'is_callable'        => '',
		],
		[
			'name'               => 'RS Framework',
			'slug'               => 'rs_framework',
			'source'             => 'https://www.rstheme.com/products/demo-data/reobiz/plugins/rs_framework.zip',
			'required'           => true,
			'version'            => '3.0.0',
			'force_activation'   => false,
			'force_deactivation' => false,
			'external_url'       => '',
			'is_callable'        => '',
		],
		[
			'name'               => 'RS Template Builder',
			'slug'               => 'rs-template-builder',
			'source'             => 'https://www.rstheme.com/products/demo-data/reobiz/plugins/rs-template-builder.zip',
			'required'           => true,
			'version'            => '1.0.1',
			'force_activation'   => false,
			'force_deactivation' => false,
			'external_url'       => '',
			'is_callable'        => '',
		],
		[
			'name'               => 'Slider Revolution',
			'slug'               => 'revslider',
			'source'             => 'https://www.rstheme.com/products/demo-data/revslider.zip',
			'required'           => true,
			'version'            => '6.7.38',
			'force_activation'   => false,
			'force_deactivation' => false,
			'external_url'       => '',
			'is_callable'        => '',
		],
	];
	// Change this to your theme text domain, used for internationalising strings
	$theme_text_domain = 'reobiz';
	$config            = array(
		'domain'       => $theme_text_domain,
		'default_path' => '',
		'menu'         => 'install-required-plugins',
		'has_notices'  => true,
		'is_automatic' => true,
		'message'      => '',
		'strings'      => array(
			'page_title'                      => __( 'Install Required Plugins', "reobiz" ),
			'menu_title'                      => __( 'Install Plugins', "reobiz" ),
			'installing'                      => __( 'Installing Plugin: %s', "reobiz" ),
			'oops'                            => __( 'Something went wrong with the plugin API.', "reobiz" ),
			'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'reobiz' ),
			'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'reobiz' ),
			'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'reobiz' ),
			'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'reobiz' ),
			'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'reobiz' ),
			'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'reobiz' ),
			'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'reobiz' ),
			'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'reobiz' ),
			'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'reobiz' ),
			'activate_link'                   => _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'reobiz' ),
			'return'                          => __( 'Return to Required Plugins Installer', "reobiz" ),
			'plugin_activated'                => __( 'Plugin activated successfully.', "reobiz" ),
			'complete'                        => __( 'All plugins installed and activated successfully. %s', "reobiz" ),
			'nag_type'                        => 'updated'
		)
	);

	tgmpa( $plugins, $config );
}