<?php
/**
 * Theme Woocommerce
 *
 * @package TLG Theme
 *
 */

/**
	UPDATE CART IN HEADER
**/
if( ! function_exists( 'roneous_woocommerce_update_cart' ) ) {
	function roneous_woocommerce_update_cart( $cartInfo ) {
		global $woocommerce;
		ob_start(); ?>
		<span class="tlg-count"><?php echo wp_specialchars_decode($woocommerce->cart->get_cart_contents_count()); ?></span>
		<?php
		$cartInfo['span.tlg-count'] = ob_get_clean();
		return $cartInfo;
	}
	add_filter('woocommerce_add_to_cart_fragments', 'roneous_woocommerce_update_cart');
}

/**
	NUMBER OF PRODUCTS PER PAGE
**/
if( ! function_exists( 'roneous_woocommerce_ppp' ) ) {
	function roneous_woocommerce_ppp() {
		return get_option( 'roneous_shop_ppp', 9 );
	}
	add_filter( 'loop_shop_per_page', 'roneous_woocommerce_ppp', 20 );
}

/**
	WOOCOMMERCE SHARE
**/
if( ! function_exists( 'roneous_woocommerce_share' ) ) {
	function roneous_woocommerce_share() {
		echo '<div class="mt32">';
		get_template_part( 'templates/post/inc', 'sharing' );
		echo '</div>';
	}
	add_action( 'woocommerce_share', 'roneous_woocommerce_share' );
}