<?php $logos = roneous_get_logo(); ?>
<div class="show-sm">
	<?php get_template_part( 'templates/header/layout', 'standard-no-top-dark' ); ?>
</div>
<div class="nav-container right-menu vertical-menu hide-sm">
	<nav class="absolute transparent side-menu height-full">
		<div class="text-center bg-dark pl-32 pr-32 height-full">
			<div class="vertical-top bg-dark above pt40 pb24">
				<a href="<?php echo esc_url(home_url('/')); ?>">
					<?php if( $logos['logo_text'] && 'text' == $logos['site_logo'] ) : ?>
                        <h1 class="logo"><?php echo esc_attr($logos['logo_text']); ?></h1>
                    <?php else: ?>
					<img class="mb40 mb-xs-24" alt="<?php echo esc_attr(get_bloginfo('title')); ?>" src="<?php echo esc_url($logos['logo_light']); ?>" />
					<?php endif; ?>
				</a>
			</div>
			<div class="vertical-alignment text-center">
				<?php
			    wp_nav_menu(
			    	array(
				        'theme_location'    => 'primary',
				        'depth'             => 3,
				        'container'         => false,
				        'container_class'   => false,
				        'menu_class'        => 'mb40 mb-xs-24 offcanvas-menu',
				        'fallback_cb'       => 'Roneous_Nav_Walker::fallback',
				        'walker'            => new Roneous_Nav_Walker()
			        )
			    );
				?>
			</div>
			<div class="vertical-bottom bg-dark above pt24 pb24">
				<?php if ( 'yes' == get_option( 'roneous_enable_copyright', 'yes' ) ) : ?>
					<div class="heading-font sm-text"><?php echo wp_kses(get_option( 'roneous_footer_copyright', esc_html__( 'Modify this text in: Appearance > Customize > Footer', 'roneous' ) ), roneous_allowed_tags()); ?></div>
				<?php endif; ?>
				<ul class="list-inline social-list"><?php echo roneous_header_social_icons(); ?></ul>
			</div>
		</div>
	</nav>
</div>