<?php
/**
 * Theme Setup
 *
 * @package TLG Theme
 *
 */

if( !function_exists('roneous_init_theme') ) {
	function roneous_init_theme() {
	    global $content_width;
	    if ( ! isset( $content_width ) ) $content_width = 1170;
	    add_editor_style( 'assets/css/editor.css' );
	    remove_post_type_support( 'portfolio', 'post-formats' );
	    if ('no' == get_option('roneous_enable_portfolio_comment', 'no')) {
	    	remove_post_type_support( 'portfolio', 'comments' );
		}
		if ('no' == get_option('roneous_enable_page_comment', 'no')) {
	    	remove_post_type_support( 'page', 'comments' );
		}
		add_post_type_support( 'page', 'excerpt' );
	}
	add_action( 'init', 'roneous_init_theme', 10 );
}

if( !function_exists('roneous_setup_theme') ) {
	function roneous_setup_theme() {
		load_theme_textdomain( 'roneous', trailingslashit( get_template_directory() ) . 'languages' );
		add_theme_support('editor-styles');
		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'align-wide' );
		add_theme_support( 'custom-background', array( 'default-color' => 'eeeeee' ) );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form' ) );
		add_theme_support( 'title-tag' );
		add_theme_support( 'woocommerce' );
		add_theme_support( 'post-formats', array('gallery', 'video', 'audio', 'quote', 'link') );
		add_theme_support( 'post-thumbnails' );
		if( class_exists( 'Woocommerce' ) ) {
			add_theme_support( 'wc-product-gallery-zoom' );
			add_theme_support( 'wc-product-gallery-lightbox' );
			add_theme_support( 'wc-product-gallery-slider' );
		}
	    add_theme_support( 'editor-color-palette', array(
	        array(
	            'name' => __( 'Primary Color', 'roneous' ),
	            'slug' => 'primary-color',
	            'color' => get_option('roneous_color_primary', '#10B8D2'),
	        ),
	        array(
	            'name' => __( 'Dark Color', 'roneous' ),
	            'slug' => 'dark-color',
	            'color' => get_option('roneous_color_bg_dark', '#1c1d1f'),
	        ),
	        array(
	            'name' => __( 'Warning Color', 'roneous' ),
	            'slug' => 'warning-color',
	            'color' => '#eaa36e',
	        ),
	        array(
	            'name' => __( 'Success Color', 'roneous' ),
	            'slug' => 'success-color',
	            'color' => '#8fae1b',
	        ),
	        array(
	            'name' => __( 'Hot Color', 'roneous' ),
	            'slug' => 'hot-color',
	            'color' => '#E41D52',
	        ),
	    ) );
		add_image_size( 'roneous_grid', 600, 400, true );
		add_image_size( 'roneous_box', 650, 600, true );
	}
	add_action( 'after_setup_theme', 'roneous_setup_theme', 10 );
}