<?php
$header_mobile 	= get_option('roneous_header_mobile', esc_html__( '+0123456789', 'roneous' ) );
$header_email 	= get_option('roneous_header_email', esc_html__( 'hello@yourmail.com', 'roneous' ) );
$logos = roneous_get_logo();
?>	
<div class="nav-utility big-utility">
	<div class="row">
		<div class="text-left col-sm-4">
			<?php if( $header_mobile ) : ?>
			    <div class="module left"><i class="ti-mobile">&nbsp;</i>
			        <span class="sub"><?php echo wp_kses($header_mobile, roneous_allowed_tags()); ?></span>
			    </div>
		    <?php endif; ?>
		    <?php if( $header_email ) : ?>
			    <div class="module left"><i class="ti-email">&nbsp;</i>
			        <span class="sub"><?php echo wp_kses($header_email, roneous_allowed_tags()); ?></span>
			    </div>
		    <?php endif; ?>
		</div>
		<div class="text-center col-sm-4">
            <a href="<?php echo esc_url(home_url('/')); ?>">
				<?php if( $logos['logo_text'] && 'text' == $logos['site_logo'] ) : ?>
                    <h1 class="logo"><?php echo esc_attr($logos['logo_text']); ?></h1>
                <?php else: ?>
                <img class="logo logo-light" alt="<?php echo esc_attr(get_bloginfo('title')); ?>" src="<?php echo esc_url($logos['logo_light']); ?>" />
                <img class="logo logo-dark" alt="<?php echo esc_attr(get_bloginfo('title')); ?>" src="<?php echo esc_url($logos['logo']); ?>" />
                <?php endif; ?>
            </a>
		</div>
		<div class="text-right col-sm-4">
			<div class="module">
				<ul class="list-inline social-list mb24">
		            <?php echo roneous_header_social_icons(); ?>
		        </ul>
		    </div>
		</div>
	</div>
</div>