<?php
    /**
     * The template for the panel header area.
     * Override this template by specifying the path where it is stored (templates_path) in your Redux config.
     *
     * @author      Redux Framework
     * @package     ReduxFramework/Templates
     * @version:    3.5.4.18
     */

    $tip_title = __( 'Developer Mode Enabled', 'redux-framework' );

    if ( $this->parent->dev_mode_forced ) {
        $is_debug     = false;
        $is_localhost = false;

        $debug_bit = '';
        if ( Redux_Helpers::isWpDebug() ) {
            $is_debug  = true;
            $debug_bit = __( 'WP_DEBUG is enabled', 'redux-framework' );
        }

        $localhost_bit = '';
        if ( Redux_Helpers::isLocalHost() ) {
            $is_localhost  = true;
            $localhost_bit = __( 'you are working in a localhost environment', 'redux-framework' );
        }

        $conjunction_bit = '';
        if ( $is_localhost && $is_debug ) {
            $conjunction_bit = ' ' . __( 'and', 'redux-framework' ) . ' ';
        }

        $tip_msg = __( 'This has been automatically enabled because', 'redux-framework' ) . ' ' . $debug_bit . $conjunction_bit . $localhost_bit . '.';
    } else {
        $tip_msg = __( 'If you are not a developer, your theme/plugin author shipped with developer mode enabled. Contact them directly to fix it.', 'redux-framework' );
    }

?>
<div id="redux-header">
    <?php if ( ! empty( $this->parent->args['display_name'] ) ) { ?>
        <div class="display_header">

            <?php if ( isset( $this->parent->args['dev_mode'] ) && $this->parent->args['dev_mode'] ) { ?>
                <div class="redux-dev-mode-notice-container redux-dev-qtip"
                     qtip-title="<?php echo esc_attr( $tip_title ); ?>"
                     qtip-content="<?php echo esc_attr( $tip_msg ); ?>">
                    <span
                        class="redux-dev-mode-notice"><?php _e( 'Developer Mode Enabled', 'redux-framework' ); ?></span>
                </div>
            <?php } elseif (isset($this->parent->args['forced_dev_mode_off']) && $this->parent->args['forced_dev_mode_off'] == true ) { ?>
                <?php $tip_title    = 'The "forced_dev_mode_off" argument has been set to true.'; ?>
                <?php $tip_msg      = 'Support options are not available while this argument is enabled.  You will also need to switch this argument to false before deploying your project.  If you are a user of this product and you are seeing this message, please contact the author of this theme/plugin.'; ?>
                <div class="redux-dev-mode-notice-container redux-dev-qtip"
                     qtip-title="<?php echo esc_attr( $tip_title ); ?>"
                     qtip-content="<?php echo esc_attr( $tip_msg ); ?>">
                    <span
                        class="redux-dev-mode-notice" style="background-color: #FF001D;"><?php _e( 'FORCED DEV MODE OFF ENABLED', 'redux-framework' ); ?></span>
                </div>

            <?php }
            /* nectar addition */

            if ( NectarThemeManager::$custom_theme_logo &&
            isset(NectarThemeManager::$custom_theme_logo['url']) &&
            !empty(NectarThemeManager::$custom_theme_logo['url']) ) {
              $theme_menu_icon = esc_attr(NectarThemeManager::$custom_theme_logo['url']);
            } else {
                $theme_menu_icon = NECTAR_FRAMEWORK_DIRECTORY . 'assets/img/icons/salient.svg';
            }
            ?>
            <div class="salient-options-logo-wrapper">
              <img src="<?php echo esc_attr($theme_menu_icon); ?>" height="20px"  alt="salient"/>
                <h2><?php
                $custom_theme_name = get_option( 'salient_custom_branding_theme_name', false );
                if ( $custom_theme_name ) {
                    echo wp_kses_post( $custom_theme_name );
                } else {
                    echo wp_kses_post( $this->parent->args['display_name'] );
                }
                ?></h2>
            </div>
        </div>

        <div class="secondary-header">
            <span class="salient-options-search-wrapper">
            <input class="redux-field-search" type="text" placeholder="<?php echo esc_attr__('Search', 'salient'); ?>" />
            <span class="salient-options-search-icon"><i class="salient-admin-icon-search"></i></span>
            <span class="salient-options-search-close"><i class="salient-admin-icon-x"></i></span>
            </span>
            <?php if ( ! empty( $this->parent->args['display_version'] ) ) { ?>
                <span class="salient-options-version">v<?php echo nectar_get_theme_version(); ?></span>
            <?php } ?>
        </div>
    <?php } ?>

    <div class="clear"></div>
</div>