<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0
 */

if ( smartseo_sidebar_present() ) {
	
	$smartseo_sidebar_type = smartseo_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $smartseo_sidebar_type && ! smartseo_is_layouts_available() ) {
		$smartseo_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $smartseo_sidebar_type ) {
		// Default sidebar with widgets
		$smartseo_sidebar_name = smartseo_get_theme_option( 'sidebar_widgets' );
		smartseo_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $smartseo_sidebar_name ) ) {
			dynamic_sidebar( $smartseo_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$smartseo_sidebar_id = smartseo_get_custom_sidebar_id();
		do_action( 'smartseo_action_show_layout', $smartseo_sidebar_id );
	}
	$smartseo_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $smartseo_out ) ) {
		$smartseo_sidebar_position    = smartseo_get_theme_option( 'sidebar_position' );
		$smartseo_sidebar_position_ss = smartseo_get_theme_option( 'sidebar_position_ss', 'below' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $smartseo_sidebar_position );
			echo ' sidebar_' . esc_attr( $smartseo_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $smartseo_sidebar_type );

			$smartseo_sidebar_scheme = apply_filters( 'smartseo_filter_sidebar_scheme', smartseo_get_theme_option( 'sidebar_scheme', 'inherit' ) );
			if ( ! empty( $smartseo_sidebar_scheme ) && ! smartseo_is_inherit( $smartseo_sidebar_scheme ) && 'custom' != $smartseo_sidebar_type ) {
				echo ' scheme_' . esc_attr( $smartseo_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="smartseo_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'smartseo_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $smartseo_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$smartseo_title = apply_filters( 'smartseo_filter_sidebar_control_title', 'float' == $smartseo_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'smartseo' ) : '' );
				$smartseo_text  = apply_filters( 'smartseo_filter_sidebar_control_text', 'above' == $smartseo_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'smartseo' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $smartseo_title ); ?>"><?php echo esc_html( $smartseo_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'smartseo_action_before_sidebar', 'sidebar' );
				smartseo_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $smartseo_out ) );
				do_action( 'smartseo_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'smartseo_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
