<?php
/**
 * The Sticky template to display the sticky posts
 *
 * Used for index/archive
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0
 */

$smartseo_columns     = max( 1, min( 3, count( get_option( 'sticky_posts' ) ) ) );
$smartseo_post_format = get_post_format();
$smartseo_post_format = empty( $smartseo_post_format ) ? 'standard' : str_replace( 'post-format-', '', $smartseo_post_format );

?><div class="column-1_<?php echo esc_attr( $smartseo_columns ); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class( 'post_item post_layout_sticky post_format_' . esc_attr( $smartseo_post_format ) );
	smartseo_add_blog_animation( $smartseo_template_args );
	?>
>

	<?php
	if ( is_sticky() && is_home() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	smartseo_show_post_featured(
		array(
			'thumb_size' => smartseo_get_thumb_size( 1 == $smartseo_columns ? 'big' : ( 2 == $smartseo_columns ? 'med' : 'avatar' ) ),
		)
	);

	if ( ! in_array( $smartseo_post_format, array( 'link', 'aside', 'status', 'quote' ) ) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( sprintf( '<h5 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h6>' );
			// Post meta
			smartseo_show_post_meta( apply_filters( 'smartseo_filter_post_meta_args', array(), 'sticky', $smartseo_columns ) );
			?>
		</div><!-- .entry-header -->
		<?php
	}
	?>
</article></div><?php

// div.column-1_X is a inline-block and new lines and spaces after it are forbidden
