<?php
/**
 * The template to display Admin notices
 *
 * @package SMARTSEO
 * @since SMARTSEO 1.0.64
 */

$smartseo_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$smartseo_skins_args = get_query_var( 'smartseo_skins_notice_args' );
?>
<div class="smartseo_admin_notice smartseo_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$smartseo_theme_img = smartseo_get_file_url( 'screenshot.jpg' );
	if ( '' != $smartseo_theme_img ) {
		?>
		<div class="smartseo_notice_image"><img src="<?php echo esc_url( $smartseo_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'smartseo' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="smartseo_notice_title">
		<?php esc_html_e( 'New skins are available', 'smartseo' ); ?>
	</h3>
	<?php

	// Description
	$smartseo_total      = $smartseo_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$smartseo_skins_msg  = $smartseo_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $smartseo_total, 'smartseo' ), $smartseo_total ) . '</strong>'
							: '';
	$smartseo_total      = $smartseo_skins_args['free'];
	$smartseo_skins_msg .= $smartseo_total > 0
							? ( ! empty( $smartseo_skins_msg ) ? ' ' . esc_html__( 'and', 'smartseo' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $smartseo_total, 'smartseo' ), $smartseo_total ) . '</strong>'
							: '';
	$smartseo_total      = $smartseo_skins_args['pay'];
	$smartseo_skins_msg .= $smartseo_skins_args['pay'] > 0
							? ( ! empty( $smartseo_skins_msg ) ? ' ' . esc_html__( 'and', 'smartseo' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $smartseo_total, 'smartseo' ), $smartseo_total ) . '</strong>'
							: '';
	?>
	<div class="smartseo_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'smartseo' ), $smartseo_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="smartseo_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $smartseo_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'smartseo' );
			?>
		</a>
	</div>
</div>
