<?php

namespace PenciAIContentGenerator\AjaxRequests;

class SuggestPostExcerpt {

	private $ajax;

	/**
	 * PreloadCaches constructor.
	 */
	public function __construct( $a ) {
		$this->ajax = $a;
		add_action( "wp_ajax_penciai_suggest_excerpt", [ $this, 'ajax' ] );
	}

	public function ajax() {
		\penciai_checkNonce();
		$main_title = isset( $_POST['main_title'] ) && ! empty( $_POST['main_title'] ) ? sanitize_text_field( $_POST['main_title'] ) : '';
		$front 		= isset( $_POST['front'] )  && $_POST['front'];
		if ( ! empty( get_theme_mod( 'penci_ai_api_key' ) ) ) {
			$ai = new \OpenAIAPI( get_theme_mod( 'penci_ai_api_key' ) );
			$default_model = get_theme_mod( 'penci_ai_model', 'gpt-3.5-turbo-instruct' );
			$ai->setModel( $default_model );

			$prompt = 'Generate an excerpt for the post titled: '  . $main_title . '. Match the language and tone of the title. Output only the excerpt content without any extra explanation or quotation marks.';

			if ( $front ) {
				$prompt = '
				Generate a full blog post with the title "'  . $main_title . '".
				The content should be minimal, abstract, or creative — inspired by the idea of "'  . $main_title . '" as a symbol, sound, or concept.
				Include only meaningful content: no author info, dates, categories, or metadata.
				Use a few relevant headings (in <h2> or <h3>), and format the result entirely in valid HTML.
				Keep paragraphs short, expressive, and clear.
				Do not include boilerplate intro/conclusion. Just rich, poetic, or thought-provoking content.
				';
			}

			$data = array(
				'temperature'       => intval( get_theme_mod( 'penci_ai_temperature' ) ),
				'max_tokens'        => 2000,
				'frequency_penalty' => 0,
				'presence_penalty'  => 0,
			);

			if ( $default_model == 'gpt-3.5-turbo-instruct' ) {
				$data['prompt'] = $prompt;
			} else {
				$data['model'] = $default_model;
				$data['messages'] = array(
					array(
						'role'    => 'user',
						'content' => $prompt,
					),
				);
			}

			if ( in_array( $default_model, [ 'gpt-5', 'gpt-5-pro', 'gpt-5-thinking' ], true ) ) {
				// Example: adjust verbosity or reasoning_effort if desired
				$data['verbosity'] = 'medium'; // options: low, medium, high
				$data['reasoning_effort'] = $default_model === 'gpt-5-thinking' ? 'high' : 'medium';
			}

			$response = $ai->complete( $data );


			$str = "";
			if ( isset( $response ) && ! empty( $response ) && penciai_is_json( $response ) ) {
				$json = json_decode( $response );

				if ( isset( $json->choices ) ) {

					if ( $default_model == 'gpt-3.5-turbo-instruct' ) {
						$str = $json->choices[0]->text;
					} else {
						$str = $json->choices[0]->message->content;
					}

					$str = penciai_remove_first_br( $str );
				} else {
					$hasError = $this->ajax->is_response_has_error( $json );
					if ( $hasError !== false ) {
						wp_send_json_error( $hasError );
					} else {
						wp_send_json_error( "__something_went_wrong__" );
					}
				}

			}

			wp_send_json_success( $str );

		}

		wp_die();

	}
}
