<?php
$options   = [];
$options[] = array(
	'default' => '',
	'label'   => __( 'Audio Service', 'penci-text-to-speech' ),
	'id'      => 'penci_texttospeech_service',
	'type'    => 'soledad-fw-select',
	'choices' => array(
		''       => esc_html__( 'Google', 'penci-text-to-speech' ),
		'openai' => esc_html__( 'OpenAI', 'penci-text-to-speech' ),
	)
);

$options[] = array(
	'id'       => 'penci_texttospeech_enabled_post_types',
	'sanitize' => 'penci_sanitize_multiple_checkbox',
	'label'    => __( 'Enable Support in Post Types', 'penci-text-to-speech' ),
	'type'     => 'soledad-fw-select',
	'multiple' => 999,
	'choices'  => call_user_func( function () {
		$types      = array();
		$exclude    = array(
			'attachment',
			'revision',
			'nav_menu_item',
			'safecss',
			'penci-block',
			'penci_builder',
			'custom-post-template',
			'archive-template',
		);
		$registered = get_post_types( [ 'show_in_nav_menus' => true ], 'objects' );


		foreach ( $registered as $post ) {

			if ( in_array( $post->name, $exclude ) ) {

				continue;
			}

			$types[ $post->name ] = $post->label;
		}

		return $types;
	} )
);

$options[] = array(
	'label' => __( 'OpenAI Settings', 'penci-text-to-speech' ),
	'id'    => 'penci_texttospeech_openai_heading',
	'type'  => 'soledad-fw-header',
);

$options[] = array(
	'default' => '',
	'label'   => __( 'API Key', 'penci-text-to-speech' ),
	'id'      => 'penci_texttospeech_openai_key',
	'type'    => 'soledad-fw-text',
);

$options[] = array(
	'default' => 'alloy',
	'label'   => __( 'Voice Options', 'penci-text-to-speech' ),
	'id'      => 'penci_texttospeech_openai_voices',
	'type'    => 'soledad-fw-select',
	'choices' => array(
		"alloy"   => "Alloy",
		"ash"     => "Ash",
		"coral"   => "Coral",
		"echo"    => "Echo",
		"fable"   => "Fable",
		"onyx"    => "Onyx",
		"nova"    => "Nova",
		"sage"    => "Sage",
		"shimmer" => "Shimmer"
	)
);

$options[] = array(
	'label' => __( 'Google API Settings', 'penci-text-to-speech' ),
	'id'    => 'penci_texttospeech_google_heading',
	'type'  => 'soledad-fw-header',
);

$options[] = array(
	'default'     => '',
	'label'       => __( 'JSON API File', 'penci-text-to-speech' ),
	'description' => __( 'This plugin uses the Google Cloud Text-to-Speech API Key File. Set up your <a target="_blank" href="https://console.cloud.google.com/cloud-resource-manager">Google Cloud Platform</a> project before the start.', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_api_key',
	'type'        => 'soledad-fw-upload',
	'priority'    => 1,
);

$options[] = array(
	'default'     => 'en-US-Standard-D',
	'label'       => __( 'Voices', 'penci-text-to-speech' ),
	'description' => __( 'The list includes Standard, WaveNet and Neural2 voice types <a href="https://cloud.google.com/text-to-speech/docs/wavenet" target="_blank" title="voice types">voice types</a>. WaveNet and Neural2 voices are higher quality voices at a different <a href="https://cloud.google.com/text-to-speech/pricing" target="_blank" title="pricing">pricing</a>.', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_language_name',
	'type'        => 'soledad-fw-select',
	'priority'    => 1,
	'choices'     => [
		'af-ZA-Standard-A'  => 'Afrikaans (South Africa) - Standard - Female',
		'ar-XA-Standard-A'  => 'Arabic - Standard - Female',
		'ar-XA-Standard-B'  => 'Arabic - Standard - Male',
		'ar-XA-Standard-C'  => 'Arabic - Standard - Male',
		'ar-XA-Standard-D'  => 'Arabic - Standard - Female',
		'ar-XA-Wavenet-A'   => 'Arabic - WaveNet - Female',
		'ar-XA-Wavenet-B'   => 'Arabic - WaveNet - Male',
		'ar-XA-Wavenet-C'   => 'Arabic - WaveNet - Male',
		'ar-XA-Wavenet-D'   => 'Arabic - WaveNet - Female',
		'eu-ES-Standard-A'  => 'Basque (Spain) - Standard - Female',
		'bn-IN-Standard-A'  => 'Bengali (India) - Standard - Female',
		'bn-IN-Standard-B'  => 'Bengali (India) - Standard - Male',
		'bn-IN-Standard-C'  => 'Bengali (India) - Standard - Female',
		'bn-IN-Standard-D'  => 'Bengali (India) - Standard - Male',
		'bn-IN-Wavenet-A'   => 'Bengali (India) - WaveNet - Female',
		'bn-IN-Wavenet-B'   => 'Bengali (India) - WaveNet - Male',
		'bn-IN-Wavenet-C'   => 'Bengali (India) - WaveNet - Female',
		'bn-IN-Wavenet-D'   => 'Bengali (India) - WaveNet - Male',
		'bg-BG-Standard-A'  => 'Bulgarian (Bulgaria) - Standard - Female',
		'ca-ES-Standard-A'  => 'Catalan (Spain) - Standard - Female',
		'yue-HK-Standard-A' => 'Chinese (Hong Kong) - Standard - Female',
		'yue-HK-Standard-B' => 'Chinese (Hong Kong) - Standard - Male',
		'yue-HK-Standard-C' => 'Chinese (Hong Kong) - Standard - Female',
		'yue-HK-Standard-D' => 'Chinese (Hong Kong) - Standard - Male',
		'cs-CZ-Standard-A'  => 'Czech (Czech Republic) - Standard - Female',
		'cs-CZ-Wavenet-A'   => 'Czech (Czech Republic) - WaveNet - Female',
		'da-DK-Neural2-D'   => 'Danish (Denmark) - Neural2 - Female',
		'da-DK-Standard-A'  => 'Danish (Denmark) - Standard - Female',
		'da-DK-Standard-C'  => 'Danish (Denmark) - Standard - Male',
		'da-DK-Standard-D'  => 'Danish (Denmark) - Standard - Female',
		'da-DK-Standard-E'  => 'Danish (Denmark) - Standard - Female',
		'da-DK-Wavenet-A'   => 'Danish (Denmark) - WaveNet - Female',
		'da-DK-Wavenet-C'   => 'Danish (Denmark) - WaveNet - Male',
		'da-DK-Wavenet-D'   => 'Danish (Denmark) - WaveNet - Female',
		'da-DK-Wavenet-E'   => 'Danish (Denmark) - WaveNet - Female',
		'nl-BE-Standard-A'  => 'Dutch (Belgium) - Standard - Female',
		'nl-BE-Standard-B'  => 'Dutch (Belgium) - Standard - Male',
		'nl-BE-Wavenet-A'   => 'Dutch (Belgium) - WaveNet - Female',
		'nl-BE-Wavenet-B'   => 'Dutch (Belgium) - WaveNet - Male',
		'nl-NL-Standard-A'  => 'Dutch (Netherlands) - Standard - Female',
		'nl-NL-Standard-B'  => 'Dutch (Netherlands) - Standard - Male',
		'nl-NL-Standard-C'  => 'Dutch (Netherlands) - Standard - Male',
		'nl-NL-Standard-D'  => 'Dutch (Netherlands) - Standard - Female',
		'nl-NL-Standard-E'  => 'Dutch (Netherlands) - Standard - Female',
		'nl-NL-Wavenet-A'   => 'Dutch (Netherlands) - WaveNet - Female',
		'nl-NL-Wavenet-B'   => 'Dutch (Netherlands) - WaveNet - Male',
		'nl-NL-Wavenet-C'   => 'Dutch (Netherlands) - WaveNet - Male',
		'nl-NL-Wavenet-D'   => 'Dutch (Netherlands) - WaveNet - Female',
		'nl-NL-Wavenet-E'   => 'Dutch (Netherlands) - WaveNet - Female',
		'en-AU-Neural2-A'   => 'English (Australia) - Neural2 - Female',
		'en-AU-Neural2-B'   => 'English (Australia) - Neural2 - Male',
		'en-AU-Neural2-C'   => 'English (Australia) - Neural2 - Female',
		'en-AU-Neural2-D'   => 'English (Australia) - Neural2 - Male',
		'en-AU-News-E'      => 'English (Australia) - WaveNet - Female',
		'en-AU-News-F'      => 'English (Australia) - WaveNet - Female',
		'en-AU-News-G'      => 'English (Australia) - WaveNet - Male',
		'en-AU-Polyglot-1'  => 'English (Australia) - Standard - Male',
		'en-AU-Standard-A'  => 'English (Australia) - Standard - Female',
		'en-AU-Standard-B'  => 'English (Australia) - Standard - Male',
		'en-AU-Standard-C'  => 'English (Australia) - Standard - Female',
		'en-AU-Standard-D'  => 'English (Australia) - Standard - Male',
		'en-AU-Wavenet-A'   => 'English (Australia) - WaveNet - Female',
		'en-AU-Wavenet-B'   => 'English (Australia) - WaveNet - Male',
		'en-AU-Wavenet-C'   => 'English (Australia) - WaveNet - Female',
		'en-AU-Wavenet-D'   => 'English (Australia) - WaveNet - Male',
		'en-IN-Neural2-A'   => 'English (India) - Neural2 - Female',
		'en-IN-Neural2-B'   => 'English (India) - Neural2 - Male',
		'en-IN-Neural2-C'   => 'English (India) - Neural2 - Male',
		'en-IN-Neural2-D'   => 'English (India) - Neural2 - Female',
		'en-IN-Standard-A'  => 'English (India) - Standard - Female',
		'en-IN-Standard-B'  => 'English (India) - Standard - Male',
		'en-IN-Standard-C'  => 'English (India) - Standard - Male',
		'en-IN-Standard-D'  => 'English (India) - Standard - Female',
		'en-IN-Wavenet-A'   => 'English (India) - WaveNet - Female',
		'en-IN-Wavenet-B'   => 'English (India) - WaveNet - Male',
		'en-IN-Wavenet-C'   => 'English (India) - WaveNet - Male',
		'en-IN-Wavenet-D'   => 'English (India) - WaveNet - Female',
		'en-GB-Neural2-A'   => 'English (UK) - Neural2 - Female',
		'en-GB-Neural2-B'   => 'English (UK) - Neural2 - Male',
		'en-GB-Neural2-C'   => 'English (UK) - Neural2 - Female',
		'en-GB-Neural2-D'   => 'English (UK) - Neural2 - Male',
		'en-GB-Neural2-F'   => 'English (UK) - Neural2 - Female',
		'en-GB-News-G'      => 'English (UK) - WaveNet - Female',
		'en-GB-News-H'      => 'English (UK) - WaveNet - Female',
		'en-GB-News-I'      => 'English (UK) - WaveNet - Female',
		'en-GB-News-J'      => 'English (UK) - WaveNet - Male',
		'en-GB-News-K'      => 'English (UK) - WaveNet - Male',
		'en-GB-News-L'      => 'English (UK) - WaveNet - Male',
		'en-GB-News-M'      => 'English (UK) - WaveNet - Male',
		'en-GB-Standard-A'  => 'English (UK) - Standard - Female',
		'en-GB-Standard-B'  => 'English (UK) - Standard - Male',
		'en-GB-Standard-C'  => 'English (UK) - Standard - Female',
		'en-GB-Standard-D'  => 'English (UK) - Standard - Male',
		'en-GB-Standard-F'  => 'English (UK) - Standard - Female',
		'en-GB-Studio-B'    => 'English (UK) - Studio - Male',
		'en-GB-Studio-C'    => 'English (UK) - Studio - Female',
		'en-GB-Wavenet-A'   => 'English (UK) - WaveNet - Female',
		'en-GB-Wavenet-B'   => 'English (UK) - WaveNet - Male',
		'en-GB-Wavenet-C'   => 'English (UK) - WaveNet - Female',
		'en-GB-Wavenet-D'   => 'English (UK) - WaveNet - Male',
		'en-GB-Wavenet-F'   => 'English (UK) - WaveNet - Female',
		'en-US-Casual-K'    => 'English (US) - Standard - Male',
		'en-US-Journey-D'   => 'English (US) - Standard - Male',
		'en-US-Journey-F'   => 'English (US) - Standard - Female',
		'en-US-Neural2-A'   => 'English (US) - Neural2 - Male',
		'en-US-Neural2-C'   => 'English (US) - Neural2 - Female',
		'en-US-Neural2-D'   => 'English (US) - Neural2 - Male',
		'en-US-Neural2-E'   => 'English (US) - Neural2 - Female',
		'en-US-Neural2-F'   => 'English (US) - Neural2 - Female',
		'en-US-Neural2-G'   => 'English (US) - Neural2 - Female',
		'en-US-Neural2-H'   => 'English (US) - Neural2 - Female',
		'en-US-Neural2-I'   => 'English (US) - Neural2 - Male',
		'en-US-Neural2-J'   => 'English (US) - Neural2 - Male',
		'en-US-News-K'      => 'English (US) - WaveNet - Female',
		'en-US-News-L'      => 'English (US) - WaveNet - Female',
		'en-US-News-N'      => 'English (US) - WaveNet - Male',
		'en-US-Polyglot-1'  => 'English (US) - Standard - Male',
		'en-US-Standard-A'  => 'English (US) - Standard - Male',
		'en-US-Standard-B'  => 'English (US) - Standard - Male',
		'en-US-Standard-C'  => 'English (US) - Standard - Female',
		'en-US-Standard-D'  => 'English (US) - Standard - Male',
		'en-US-Standard-E'  => 'English (US) - Standard - Female',
		'en-US-Standard-F'  => 'English (US) - Standard - Female',
		'en-US-Standard-G'  => 'English (US) - Standard - Female',
		'en-US-Standard-H'  => 'English (US) - Standard - Female',
		'en-US-Standard-I'  => 'English (US) - Standard - Male',
		'en-US-Standard-J'  => 'English (US) - Standard - Male',
		'en-US-Studio-O'    => 'English (US) - Studio - Female',
		'en-US-Studio-Q'    => 'English (US) - Studio - Male',
		'en-US-Wavenet-A'   => 'English (US) - WaveNet - Male',
		'en-US-Wavenet-B'   => 'English (US) - WaveNet - Male',
		'en-US-Wavenet-C'   => 'English (US) - WaveNet - Female',
		'en-US-Wavenet-D'   => 'English (US) - WaveNet - Male',
		'en-US-Wavenet-E'   => 'English (US) - WaveNet - Female',
		'en-US-Wavenet-F'   => 'English (US) - WaveNet - Female',
		'en-US-Wavenet-G'   => 'English (US) - WaveNet - Female',
		'en-US-Wavenet-H'   => 'English (US) - WaveNet - Female',
		'en-US-Wavenet-I'   => 'English (US) - WaveNet - Male',
		'en-US-Wavenet-J'   => 'English (US) - WaveNet - Male',
		'fil-PH-Standard-A' => 'Filipino (Philippines) - Standard - Female',
		'fil-PH-Standard-B' => 'Filipino (Philippines) - Standard - Female',
		'fil-PH-Standard-C' => 'Filipino (Philippines) - Standard - Male',
		'fil-PH-Standard-D' => 'Filipino (Philippines) - Standard - Male',
		'fil-PH-Wavenet-A'  => 'Filipino (Philippines) - WaveNet - Female',
		'fil-PH-Wavenet-B'  => 'Filipino (Philippines) - WaveNet - Female',
		'fil-PH-Wavenet-C'  => 'Filipino (Philippines) - WaveNet - Male',
		'fil-PH-Wavenet-D'  => 'Filipino (Philippines) - WaveNet - Male',
		'fil-ph-Neural2-A'  => 'Filipino (Philippines) - Neural2 - Female',
		'fil-ph-Neural2-D'  => 'Filipino (Philippines) - Neural2 - Male',
		'fi-FI-Standard-A'  => 'Finnish (Finland) - Standard - Female',
		'fi-FI-Wavenet-A'   => 'Finnish (Finland) - WaveNet - Female',
		'fr-CA-Neural2-A'   => 'French (Canada) - Neural2 - Female',
		'fr-CA-Neural2-B'   => 'French (Canada) - Neural2 - Male',
		'fr-CA-Neural2-C'   => 'French (Canada) - Neural2 - Female',
		'fr-CA-Neural2-D'   => 'French (Canada) - Neural2 - Male',
		'fr-CA-Standard-A'  => 'French (Canada) - Standard - Female',
		'fr-CA-Standard-B'  => 'French (Canada) - Standard - Male',
		'fr-CA-Standard-C'  => 'French (Canada) - Standard - Female',
		'fr-CA-Standard-D'  => 'French (Canada) - Standard - Male',
		'fr-CA-Wavenet-A'   => 'French (Canada) - WaveNet - Female',
		'fr-CA-Wavenet-B'   => 'French (Canada) - WaveNet - Male',
		'fr-CA-Wavenet-C'   => 'French (Canada) - WaveNet - Female',
		'fr-CA-Wavenet-D'   => 'French (Canada) - WaveNet - Male',
		'fr-FR-Neural2-A'   => 'French (France) - Neural2 - Female',
		'fr-FR-Neural2-B'   => 'French (France) - Neural2 - Male',
		'fr-FR-Neural2-C'   => 'French (France) - Neural2 - Female',
		'fr-FR-Neural2-D'   => 'French (France) - Neural2 - Male',
		'fr-FR-Neural2-E'   => 'French (France) - Neural2 - Female',
		'fr-FR-Polyglot-1'  => 'French (France) - Standard - Male',
		'fr-FR-Standard-A'  => 'French (France) - Standard - Female',
		'fr-FR-Standard-B'  => 'French (France) - Standard - Male',
		'fr-FR-Standard-C'  => 'French (France) - Standard - Female',
		'fr-FR-Standard-D'  => 'French (France) - Standard - Male',
		'fr-FR-Standard-E'  => 'French (France) - Standard - Female',
		'fr-FR-Studio-A'    => 'French (France) - Studio - Female',
		'fr-FR-Studio-D'    => 'French (France) - Studio - Male',
		'fr-FR-Wavenet-A'   => 'French (France) - WaveNet - Female',
		'fr-FR-Wavenet-B'   => 'French (France) - WaveNet - Male',
		'fr-FR-Wavenet-C'   => 'French (France) - WaveNet - Female',
		'fr-FR-Wavenet-D'   => 'French (France) - WaveNet - Male',
		'fr-FR-Wavenet-E'   => 'French (France) - WaveNet - Female',
		'gl-ES-Standard-A'  => 'Galician (Spain) - Standard - Female',
		'de-DE-Neural2-A'   => 'German (Germany) - Neural2 - Female',
		'de-DE-Neural2-B'   => 'German (Germany) - Neural2 - Male',
		'de-DE-Neural2-C'   => 'German (Germany) - Neural2 - Female',
		'de-DE-Neural2-D'   => 'German (Germany) - Neural2 - Male',
		'de-DE-Neural2-F'   => 'German (Germany) - Neural2 - Female',
		'de-DE-Polyglot-1'  => 'German (Germany) - Standard - Male',
		'de-DE-Standard-A'  => 'German (Germany) - Standard - Female',
		'de-DE-Standard-B'  => 'German (Germany) - Standard - Male',
		'de-DE-Standard-C'  => 'German (Germany) - Standard - Female',
		'de-DE-Standard-D'  => 'German (Germany) - Standard - Male',
		'de-DE-Standard-E'  => 'German (Germany) - Standard - Male',
		'de-DE-Standard-F'  => 'German (Germany) - Standard - Female',
		'de-DE-Studio-B'    => 'German (Germany) - Studio - Male',
		'de-DE-Studio-C'    => 'German (Germany) - Studio - Female',
		'de-DE-Wavenet-A'   => 'German (Germany) - WaveNet - Female',
		'de-DE-Wavenet-B'   => 'German (Germany) - WaveNet - Male',
		'de-DE-Wavenet-C'   => 'German (Germany) - WaveNet - Female',
		'de-DE-Wavenet-D'   => 'German (Germany) - WaveNet - Male',
		'de-DE-Wavenet-E'   => 'German (Germany) - WaveNet - Male',
		'de-DE-Wavenet-F'   => 'German (Germany) - WaveNet - Female',
		'el-GR-Standard-A'  => 'Greek (Greece) - Standard - Female',
		'el-GR-Wavenet-A'   => 'Greek (Greece) - WaveNet - Female',
		'gu-IN-Standard-A'  => 'Gujarati (India) - Standard - Female',
		'gu-IN-Standard-B'  => 'Gujarati (India) - Standard - Male',
		'gu-IN-Wavenet-A'   => 'Gujarati (India) - WaveNet - Female',
		'gu-IN-Wavenet-B'   => 'Gujarati (India) - WaveNet - Male',
		'he-IL-Standard-A'  => 'Hebrew (Israel) - Standard - Female',
		'he-IL-Standard-B'  => 'Hebrew (Israel) - Standard - Male',
		'he-IL-Standard-C'  => 'Hebrew (Israel) - Standard - Female',
		'he-IL-Standard-D'  => 'Hebrew (Israel) - Standard - Male',
		'he-IL-Wavenet-A'   => 'Hebrew (Israel) - WaveNet - Female',
		'he-IL-Wavenet-B'   => 'Hebrew (Israel) - WaveNet - Male',
		'he-IL-Wavenet-C'   => 'Hebrew (Israel) - WaveNet - Female',
		'he-IL-Wavenet-D'   => 'Hebrew (Israel) - WaveNet - Male',
		'hi-IN-Neural2-A'   => 'Hindi (India) - Neural2 - Female',
		'hi-IN-Neural2-B'   => 'Hindi (India) - Neural2 - Male',
		'hi-IN-Neural2-C'   => 'Hindi (India) - Neural2 - Male',
		'hi-IN-Neural2-D'   => 'Hindi (India) - Neural2 - Female',
		'hi-IN-Standard-A'  => 'Hindi (India) - Standard - Female',
		'hi-IN-Standard-B'  => 'Hindi (India) - Standard - Male',
		'hi-IN-Standard-C'  => 'Hindi (India) - Standard - Male',
		'hi-IN-Standard-D'  => 'Hindi (India) - Standard - Female',
		'hi-IN-Wavenet-A'   => 'Hindi (India) - WaveNet - Female',
		'hi-IN-Wavenet-B'   => 'Hindi (India) - WaveNet - Male',
		'hi-IN-Wavenet-C'   => 'Hindi (India) - WaveNet - Male',
		'hi-IN-Wavenet-D'   => 'Hindi (India) - WaveNet - Female',
		'hu-HU-Standard-A'  => 'Hungarian (Hungary) - Standard - Female',
		'hu-HU-Wavenet-A'   => 'Hungarian (Hungary) - WaveNet - Female',
		'is-IS-Standard-A'  => 'Icelandic (Iceland) - Standard - Female',
		'id-ID-Standard-A'  => 'Indonesian (Indonesia) - Standard - Female',
		'id-ID-Standard-B'  => 'Indonesian (Indonesia) - Standard - Male',
		'id-ID-Standard-C'  => 'Indonesian (Indonesia) - Standard - Male',
		'id-ID-Standard-D'  => 'Indonesian (Indonesia) - Standard - Female',
		'id-ID-Wavenet-A'   => 'Indonesian (Indonesia) - WaveNet - Female',
		'id-ID-Wavenet-B'   => 'Indonesian (Indonesia) - WaveNet - Male',
		'id-ID-Wavenet-C'   => 'Indonesian (Indonesia) - WaveNet - Male',
		'id-ID-Wavenet-D'   => 'Indonesian (Indonesia) - WaveNet - Female',
		'it-IT-Neural2-A'   => 'Italian (Italy) - Neural2 - Female',
		'it-IT-Neural2-C'   => 'Italian (Italy) - Neural2 - Male',
		'it-IT-Standard-A'  => 'Italian (Italy) - Standard - Female',
		'it-IT-Standard-B'  => 'Italian (Italy) - Standard - Female',
		'it-IT-Standard-C'  => 'Italian (Italy) - Standard - Male',
		'it-IT-Standard-D'  => 'Italian (Italy) - Standard - Male',
		'it-IT-Wavenet-A'   => 'Italian (Italy) - WaveNet - Female',
		'it-IT-Wavenet-B'   => 'Italian (Italy) - WaveNet - Female',
		'it-IT-Wavenet-C'   => 'Italian (Italy) - WaveNet - Male',
		'it-IT-Wavenet-D'   => 'Italian (Italy) - WaveNet - Male',
		'ja-JP-Neural2-B'   => 'Japanese (Japan) - Neural2 - Female',
		'ja-JP-Neural2-C'   => 'Japanese (Japan) - Neural2 - Male',
		'ja-JP-Neural2-D'   => 'Japanese (Japan) - Neural2 - Male',
		'ja-JP-Standard-A'  => 'Japanese (Japan) - Standard - Female',
		'ja-JP-Standard-B'  => 'Japanese (Japan) - Standard - Female',
		'ja-JP-Standard-C'  => 'Japanese (Japan) - Standard - Male',
		'ja-JP-Standard-D'  => 'Japanese (Japan) - Standard - Male',
		'ja-JP-Wavenet-A'   => 'Japanese (Japan) - WaveNet - Female',
		'ja-JP-Wavenet-B'   => 'Japanese (Japan) - WaveNet - Female',
		'ja-JP-Wavenet-C'   => 'Japanese (Japan) - WaveNet - Male',
		'ja-JP-Wavenet-D'   => 'Japanese (Japan) - WaveNet - Male',
		'kn-IN-Standard-A'  => 'Kannada (India) - Standard - Female',
		'kn-IN-Standard-B'  => 'Kannada (India) - Standard - Male',
		'kn-IN-Standard-C'  => 'Kannada (India) - Standard - Female',
		'kn-IN-Standard-D'  => 'Kannada (India) - Standard - Male',
		'kn-IN-Wavenet-A'   => 'Kannada (India) - WaveNet - Female',
		'kn-IN-Wavenet-B'   => 'Kannada (India) - WaveNet - Male',
		'kn-IN-Wavenet-C'   => 'Kannada (India) - WaveNet - Female',
		'kn-IN-Wavenet-D'   => 'Kannada (India) - WaveNet - Male',
		'ko-KR-Neural2-A'   => 'Korean (South Korea) - Neural2 - Female',
		'ko-KR-Neural2-B'   => 'Korean (South Korea) - Neural2 - Female',
		'ko-KR-Neural2-C'   => 'Korean (South Korea) - Neural2 - Male',
		'ko-KR-Standard-A'  => 'Korean (South Korea) - Standard - Female',
		'ko-KR-Standard-B'  => 'Korean (South Korea) - Standard - Female',
		'ko-KR-Standard-C'  => 'Korean (South Korea) - Standard - Male',
		'ko-KR-Standard-D'  => 'Korean (South Korea) - Standard - Male',
		'ko-KR-Wavenet-A'   => 'Korean (South Korea) - WaveNet - Female',
		'ko-KR-Wavenet-B'   => 'Korean (South Korea) - WaveNet - Female',
		'ko-KR-Wavenet-C'   => 'Korean (South Korea) - WaveNet - Male',
		'ko-KR-Wavenet-D'   => 'Korean (South Korea) - WaveNet - Male',
		'lv-LV-Standard-A'  => 'Latvian (Latvia) - Standard - Male',
		'lt-LT-Standard-A'  => 'Lithuanian (Lithuania) - Standard - Male',
		'ms-MY-Standard-A'  => 'Malay (Malaysia) - Standard - Female',
		'ms-MY-Standard-B'  => 'Malay (Malaysia) - Standard - Male',
		'ms-MY-Standard-C'  => 'Malay (Malaysia) - Standard - Female',
		'ms-MY-Standard-D'  => 'Malay (Malaysia) - Standard - Male',
		'ms-MY-Wavenet-A'   => 'Malay (Malaysia) - WaveNet - Female',
		'ms-MY-Wavenet-B'   => 'Malay (Malaysia) - WaveNet - Male',
		'ms-MY-Wavenet-C'   => 'Malay (Malaysia) - WaveNet - Female',
		'ms-MY-Wavenet-D'   => 'Malay (Malaysia) - WaveNet - Male',
		'ml-IN-Standard-A'  => 'Malayalam (India) - Standard - Female',
		'ml-IN-Standard-B'  => 'Malayalam (India) - Standard - Male',
		'ml-IN-Wavenet-A'   => 'Malayalam (India) - WaveNet - Female',
		'ml-IN-Wavenet-B'   => 'Malayalam (India) - WaveNet - Male',
		'ml-IN-Wavenet-C'   => 'Malayalam (India) - WaveNet - Female',
		'ml-IN-Wavenet-D'   => 'Malayalam (India) - WaveNet - Male',
		'cmn-CN-Standard-A' => 'Mandarin Chinese - Standard - Female',
		'cmn-CN-Standard-B' => 'Mandarin Chinese - Standard - Male',
		'cmn-CN-Standard-C' => 'Mandarin Chinese - Standard - Male',
		'cmn-CN-Standard-D' => 'Mandarin Chinese - Standard - Female',
		'cmn-CN-Wavenet-A'  => 'Mandarin Chinese - WaveNet - Female',
		'cmn-CN-Wavenet-B'  => 'Mandarin Chinese - WaveNet - Male',
		'cmn-CN-Wavenet-C'  => 'Mandarin Chinese - WaveNet - Male',
		'cmn-CN-Wavenet-D'  => 'Mandarin Chinese - WaveNet - Female',
		'cmn-TW-Standard-A' => 'Mandarin Chinese - Standard - Female',
		'cmn-TW-Standard-B' => 'Mandarin Chinese - Standard - Male',
		'cmn-TW-Standard-C' => 'Mandarin Chinese - Standard - Male',
		'cmn-TW-Wavenet-A'  => 'Mandarin Chinese - WaveNet - Female',
		'cmn-TW-Wavenet-B'  => 'Mandarin Chinese - WaveNet - Male',
		'cmn-TW-Wavenet-C'  => 'Mandarin Chinese - WaveNet - Male',
		'mr-IN-Standard-A'  => 'Marathi (India) - Standard - Female',
		'mr-IN-Standard-B'  => 'Marathi (India) - Standard - Male',
		'mr-IN-Standard-C'  => 'Marathi (India) - Standard - Female',
		'mr-IN-Wavenet-A'   => 'Marathi (India) - WaveNet - Female',
		'mr-IN-Wavenet-B'   => 'Marathi (India) - WaveNet - Male',
		'mr-IN-Wavenet-C'   => 'Marathi (India) - WaveNet - Female',
		'nb-NO-Standard-A'  => 'Norwegian (Norway) - Standard - Female',
		'nb-NO-Standard-B'  => 'Norwegian (Norway) - Standard - Male',
		'nb-NO-Standard-C'  => 'Norwegian (Norway) - Standard - Female',
		'nb-NO-Standard-D'  => 'Norwegian (Norway) - Standard - Male',
		'nb-NO-Standard-E'  => 'Norwegian (Norway) - Standard - Female',
		'nb-NO-Wavenet-A'   => 'Norwegian (Norway) - WaveNet - Female',
		'nb-NO-Wavenet-B'   => 'Norwegian (Norway) - WaveNet - Male',
		'nb-NO-Wavenet-C'   => 'Norwegian (Norway) - WaveNet - Female',
		'nb-NO-Wavenet-D'   => 'Norwegian (Norway) - WaveNet - Male',
		'nb-NO-Wavenet-E'   => 'Norwegian (Norway) - WaveNet - Female',
		'pl-PL-Standard-A'  => 'Polish (Poland) - Standard - Female',
		'pl-PL-Standard-B'  => 'Polish (Poland) - Standard - Male',
		'pl-PL-Standard-C'  => 'Polish (Poland) - Standard - Male',
		'pl-PL-Standard-D'  => 'Polish (Poland) - Standard - Female',
		'pl-PL-Standard-E'  => 'Polish (Poland) - Standard - Female',
		'pl-PL-Wavenet-A'   => 'Polish (Poland) - WaveNet - Female',
		'pl-PL-Wavenet-B'   => 'Polish (Poland) - WaveNet - Male',
		'pl-PL-Wavenet-C'   => 'Polish (Poland) - WaveNet - Male',
		'pl-PL-Wavenet-D'   => 'Polish (Poland) - WaveNet - Female',
		'pl-PL-Wavenet-E'   => 'Polish (Poland) - WaveNet - Female',
		'pt-BR-Neural2-A'   => 'Portuguese (Brazil) - Neural2 - Female',
		'pt-BR-Neural2-B'   => 'Portuguese (Brazil) - Neural2 - Male',
		'pt-BR-Neural2-C'   => 'Portuguese (Brazil) - Neural2 - Female',
		'pt-BR-Standard-A'  => 'Portuguese (Brazil) - Standard - Female',
		'pt-BR-Standard-B'  => 'Portuguese (Brazil) - Standard - Male',
		'pt-BR-Standard-C'  => 'Portuguese (Brazil) - Standard - Female',
		'pt-BR-Wavenet-A'   => 'Portuguese (Brazil) - WaveNet - Female',
		'pt-BR-Wavenet-B'   => 'Portuguese (Brazil) - WaveNet - Male',
		'pt-BR-Wavenet-C'   => 'Portuguese (Brazil) - WaveNet - Female',
		'pt-PT-Standard-A'  => 'Portuguese (Portugal) - Standard - Female',
		'pt-PT-Standard-B'  => 'Portuguese (Portugal) - Standard - Male',
		'pt-PT-Standard-C'  => 'Portuguese (Portugal) - Standard - Male',
		'pt-PT-Standard-D'  => 'Portuguese (Portugal) - Standard - Female',
		'pt-PT-Wavenet-A'   => 'Portuguese (Portugal) - WaveNet - Female',
		'pt-PT-Wavenet-B'   => 'Portuguese (Portugal) - WaveNet - Male',
		'pt-PT-Wavenet-C'   => 'Portuguese (Portugal) - WaveNet - Male',
		'pt-PT-Wavenet-D'   => 'Portuguese (Portugal) - WaveNet - Female',
		'pa-IN-Standard-A'  => 'Punjabi (India) - Standard - Female',
		'pa-IN-Standard-B'  => 'Punjabi (India) - Standard - Male',
		'pa-IN-Standard-C'  => 'Punjabi (India) - Standard - Female',
		'pa-IN-Standard-D'  => 'Punjabi (India) - Standard - Male',
		'pa-IN-Wavenet-A'   => 'Punjabi (India) - WaveNet - Female',
		'pa-IN-Wavenet-B'   => 'Punjabi (India) - WaveNet - Male',
		'pa-IN-Wavenet-C'   => 'Punjabi (India) - WaveNet - Female',
		'pa-IN-Wavenet-D'   => 'Punjabi (India) - WaveNet - Male',
		'ro-RO-Standard-A'  => 'Romanian (Romania) - Standard - Female',
		'ro-RO-Wavenet-A'   => 'Romanian (Romania) - WaveNet - Female',
		'ru-RU-Standard-A'  => 'Russian (Russia) - Standard - Female',
		'ru-RU-Standard-B'  => 'Russian (Russia) - Standard - Male',
		'ru-RU-Standard-C'  => 'Russian (Russia) - Standard - Female',
		'ru-RU-Standard-D'  => 'Russian (Russia) - Standard - Male',
		'ru-RU-Standard-E'  => 'Russian (Russia) - Standard - Female',
		'ru-RU-Wavenet-A'   => 'Russian (Russia) - WaveNet - Female',
		'ru-RU-Wavenet-B'   => 'Russian (Russia) - WaveNet - Male',
		'ru-RU-Wavenet-C'   => 'Russian (Russia) - WaveNet - Female',
		'ru-RU-Wavenet-D'   => 'Russian (Russia) - WaveNet - Male',
		'ru-RU-Wavenet-E'   => 'Russian (Russia) - WaveNet - Female',
		'sr-RS-Standard-A'  => 'Serbian (Cyrillic) - Standard - Female',
		'sk-SK-Standard-A'  => 'Slovak (Slovakia) - Standard - Female',
		'sk-SK-Wavenet-A'   => 'Slovak (Slovakia) - WaveNet - Female',
		'es-ES-Neural2-A'   => 'Spanish (Spain) - Neural2 - Female',
		'es-ES-Neural2-B'   => 'Spanish (Spain) - Neural2 - Male',
		'es-ES-Neural2-C'   => 'Spanish (Spain) - Neural2 - Female',
		'es-ES-Neural2-D'   => 'Spanish (Spain) - Neural2 - Female',
		'es-ES-Neural2-E'   => 'Spanish (Spain) - Neural2 - Female',
		'es-ES-Neural2-F'   => 'Spanish (Spain) - Neural2 - Male',
		'es-ES-Polyglot-1'  => 'Spanish (Spain) - Standard - Male',
		'es-ES-Standard-A'  => 'Spanish (Spain) - Standard - Female',
		'es-ES-Standard-B'  => 'Spanish (Spain) - Standard - Male',
		'es-ES-Standard-C'  => 'Spanish (Spain) - Standard - Female',
		'es-ES-Standard-D'  => 'Spanish (Spain) - Standard - Female',
		'es-ES-Wavenet-B'   => 'Spanish (Spain) - WaveNet - Male',
		'es-ES-Wavenet-C'   => 'Spanish (Spain) - WaveNet - Female',
		'es-ES-Wavenet-D'   => 'Spanish (Spain) - WaveNet - Female',
		'es-US-Neural2-A'   => 'Spanish (US) - Neural2 - Female',
		'es-US-Neural2-B'   => 'Spanish (US) - Neural2 - Male',
		'es-US-Neural2-C'   => 'Spanish (US) - Neural2 - Male',
		'es-US-News-D'      => 'Spanish (US) - WaveNet - Male',
		'es-US-News-E'      => 'Spanish (US) - WaveNet - Male',
		'es-US-News-F'      => 'Spanish (US) - WaveNet - Female',
		'es-US-News-G'      => 'Spanish (US) - WaveNet - Female',
		'es-US-Polyglot-1'  => 'Spanish (US) - Standard - Male',
		'es-US-Standard-A'  => 'Spanish (US) - Standard - Female',
		'es-US-Standard-B'  => 'Spanish (US) - Standard - Male',
		'es-US-Standard-C'  => 'Spanish (US) - Standard - Male',
		'es-US-Studio-B'    => 'Spanish (US) - Studio - Male',
		'es-US-Wavenet-A'   => 'Spanish (US) - WaveNet - Female',
		'es-US-Wavenet-B'   => 'Spanish (US) - WaveNet - Male',
		'es-US-Wavenet-C'   => 'Spanish (US) - WaveNet - Male',
		'sv-SE-Standard-A'  => 'Swedish (Sweden) - Standard - Female',
		'sv-SE-Standard-B'  => 'Swedish (Sweden) - Standard - Female',
		'sv-SE-Standard-C'  => 'Swedish (Sweden) - Standard - Female',
		'sv-SE-Standard-D'  => 'Swedish (Sweden) - Standard - Male',
		'sv-SE-Standard-E'  => 'Swedish (Sweden) - Standard - Male',
		'sv-SE-Wavenet-A'   => 'Swedish (Sweden) - WaveNet - Female',
		'sv-SE-Wavenet-B'   => 'Swedish (Sweden) - WaveNet - Female',
		'sv-SE-Wavenet-C'   => 'Swedish (Sweden) - WaveNet - Male',
		'sv-SE-Wavenet-D'   => 'Swedish (Sweden) - WaveNet - Female',
		'sv-SE-Wavenet-E'   => 'Swedish (Sweden) - WaveNet - Male',
		'ta-IN-Standard-A'  => 'Tamil (India) - Standard - Female',
		'ta-IN-Standard-B'  => 'Tamil (India) - Standard - Male',
		'ta-IN-Standard-C'  => 'Tamil (India) - Standard - Female',
		'ta-IN-Standard-D'  => 'Tamil (India) - Standard - Male',
		'ta-IN-Wavenet-A'   => 'Tamil (India) - WaveNet - Female',
		'ta-IN-Wavenet-B'   => 'Tamil (India) - WaveNet - Male',
		'ta-IN-Wavenet-C'   => 'Tamil (India) - WaveNet - Female',
		'ta-IN-Wavenet-D'   => 'Tamil (India) - WaveNet - Male',
		'te-IN-Standard-A'  => 'Telugu (India) - Standard - Female',
		'te-IN-Standard-B'  => 'Telugu (India) - Standard - Male',
		'th-TH-Neural2-C'   => 'Thai (Thailand) - Neural2 - Female',
		'th-TH-Standard-A'  => 'Thai (Thailand) - Standard - Female',
		'tr-TR-Standard-A'  => 'Turkish (Turkey) - Standard - Female',
		'tr-TR-Standard-B'  => 'Turkish (Turkey) - Standard - Male',
		'tr-TR-Standard-C'  => 'Turkish (Turkey) - Standard - Female',
		'tr-TR-Standard-D'  => 'Turkish (Turkey) - Standard - Female',
		'tr-TR-Standard-E'  => 'Turkish (Turkey) - Standard - Male',
		'tr-TR-Wavenet-A'   => 'Turkish (Turkey) - WaveNet - Female',
		'tr-TR-Wavenet-B'   => 'Turkish (Turkey) - WaveNet - Male',
		'tr-TR-Wavenet-C'   => 'Turkish (Turkey) - WaveNet - Female',
		'tr-TR-Wavenet-D'   => 'Turkish (Turkey) - WaveNet - Female',
		'tr-TR-Wavenet-E'   => 'Turkish (Turkey) - WaveNet - Male',
		'uk-UA-Standard-A'  => 'Ukrainian (Ukraine) - Standard - Female',
		'uk-UA-Wavenet-A'   => 'Ukrainian (Ukraine) - WaveNet - Female',
		'vi-VN-Neural2-A'   => 'Vietnamese (Vietnam) - Neural2 - Female',
		'vi-VN-Neural2-D'   => 'Vietnamese (Vietnam) - Neural2 - Male',
		'vi-VN-Standard-A'  => 'Vietnamese (Vietnam) - Standard - Female',
		'vi-VN-Standard-B'  => 'Vietnamese (Vietnam) - Standard - Male',
		'vi-VN-Standard-C'  => 'Vietnamese (Vietnam) - Standard - Female',
		'vi-VN-Standard-D'  => 'Vietnamese (Vietnam) - Standard - Male',
		'vi-VN-Wavenet-A'   => 'Vietnamese (Vietnam) - WaveNet - Female',
		'vi-VN-Wavenet-B'   => 'Vietnamese (Vietnam) - WaveNet - Male',
		'vi-VN-Wavenet-C'   => 'Vietnamese (Vietnam) - WaveNet - Female',
		'vi-VN-Wavenet-D'   => 'Vietnamese (Vietnam) - WaveNet - Male',
	]

);

$options[] = array(
	'default'     => 'wearable-class-device',
	'label'       => __( 'Audio Profile', 'penci-text-to-speech' ),
	'description' => __( 'Optimize the synthetic speech for playback on different types of hardware.', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_audio_profile',
	'type'        => 'soledad-fw-select',
	'priority'    => 1,
	'choices'     => array(
		'wearable-class-device'                 => esc_html__( 'Smart watches and other wearables', 'penci-text-to-speech' ),
		'handset-class-device'                  => esc_html__( 'Smartphones', 'penci-text-to-speech' ),
		'headphone-class-device'                => esc_html__( 'Earbuds or headphones', 'penci-text-to-speech' ),
		'small-bluetooth-speaker-class-device'  => esc_html__( 'Small home speakers', 'penci-text-to-speech' ),
		'medium-bluetooth-speaker-class-device' => esc_html__( 'Smart home speakers', 'penci-text-to-speech' ),
		'large-home-entertainment-class-device' => esc_html__( 'Home entertainment systems', 'penci-text-to-speech' ),
		'large-automotive-class-device'         => esc_html__( 'Car speakers', 'penci-text-to-speech' ),
		'telephony-class-application'           => esc_html__( 'Interactive Voice Response', 'penci-text-to-speech' ),
	)
);

$options[] = array(
	'default'  => 0,
	'label'    => __( 'Pitch', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_pitch',
	'type'     => 'soledad-fw-slider',
	'priority' => 1,
	'choices'  => array(
		"min"  => - 20,
		"max"  => 20,
		"step" => 0.1,
	)
);

$options[] = array(
	'label' => __( 'Other Settings', 'penci-text-to-speech' ),
	'id'    => 'penci_texttospeech_other_settings',
	'type'  => 'soledad-fw-header',
);

$options[] = array(
	'default'     => 'mp3',
	'label'       => __( 'Audio Format', 'penci-text-to-speech' ),
	'description' => __( 'Select the format in which the audio will be sent. All recordings in other formats will become unavailable.', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_audio_format',
	'type'        => 'soledad-fw-select',
	'priority'    => 1,
	'choices'     => array(
		"mp3" => esc_html__( 'MP3', 'penci-text-to-speech' ),
		"wav" => esc_html__( 'WAV', 'penci-text-to-speech' ),
	)
);

$options[] = array(
	'default'  => 1,
	'label'    => __( 'Speaking Rate', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_speaking_rate',
	'type'     => 'soledad-fw-slider',
	'priority' => 1,
	'choices'  => array(
		"min"  => 0.25,
		"max"  => 4.0,
		"step" => 0.1,
	)
);

$options[] = array(
	'label'    => __( 'Add Schema Markup on Header', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_schema',
	'type'     => 'soledad-fw-toggle',
	'default'  => false,
	'sanitize' => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'    => __( 'Add Custom Content Before Audio', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_before_audio',
	'type'     => 'soledad-fw-textarea',
	'default'  => '',
	'sanitize' => 'penci_sanitize_choices_field'
);

$options[] = array(
	'label'    => __( 'Add Custom Content After Audio', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_after_audio',
	'type'     => 'soledad-fw-textarea',
	'default'  => '',
	'sanitize' => 'penci_sanitize_choices_field'
);

$options[] = array(
	'label'    => __( 'Read the Post Title & Sub Title', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_read_title',
	'type'     => 'soledad-fw-toggle',
	'default'  => true,
	'sanitize' => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'    => __( 'Read Image Caption', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_read_figcaption',
	'type'     => 'soledad-fw-toggle',
	'default'  => false,
	'sanitize' => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'    => __( 'Show Audio File on RSS Feed', 'penci-text-to-speech' ),
	'id'       => 'penci_texttospeech_podcasts_rss',
	'type'     => 'soledad-fw-toggle',
	'default'  => false,
	'sanitize' => 'penci_sanitize_checkbox_field'
);

$options[] = array(
	'label'       => __( 'Exclude Custom Selectors', 'penci-text-to-speech' ),
	'description' => __( 'Enter the div wrapper of the text area you want to excluded on the audio file. Example: .related-posts, .shorcode-output', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_excluded_html',
	'type'        => 'soledad-fw-textarea',
	'default'     => '',
	'sanitize'    => 'penci_sanitize_choices_field'
);

$options[] = array(
	'label'       => __( 'Ignore Shortcodes', 'penci-text-to-speech' ),
	'description' => __( 'Enter the shortcode you want to ignore on the audio file. Example: shortcode-1, shortcode-2, ...', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_excluded_shortcode',
	'type'        => 'soledad-fw-textarea',
	'default'     => '',
	'sanitize'    => 'penci_sanitize_choices_field'
);

$options[] = array(
	'label'       => __( 'RegEx Peplacements', 'penci-text-to-speech' ),
	'description' => __( 'Enter the regular expression to be replaced and on a new line write the term or SSML tag to be replaced.', 'penci-text-to-speech' ),
	'id'          => 'penci_texttospeech_regex',
	'type'        => 'soledad-fw-textarea',
	'default'     => '',
	'sanitize'    => 'penci_sanitize_choices_field'
);

return $options;