<?php
get_header();
$title_acls = 'pcatitle-' . get_theme_mod( 'penci_archive_titlealign', 'default' );
?>
    <div class="container penci-bl-user-list penci-bl-user-filter">
        
        <div class="archive-box">
            <div class="title-bar <?php echo $title_acls; ?>">
				<?php
				the_archive_title( '<h1 class="page-title">', '</h1>' );
				do_action( 'penci_archive_follow_button' )
				?>
            </div>
        </div>

		<?php
        the_archive_description( '<div class="post-entry penci-category-description penci-archive-description">', '</div>' );
        ?>
		<?php if ( have_posts() ) : ?>
            <div class="penci-prankings-box-wrapper penci-billard-style-2">
				<?php
				$paged        = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
				$player_count = 1 * ( $paged - 1 ) * get_option( 'posts_per_page' ) + 1;
				while ( have_posts() ) : the_post();
					$country  = get_post_meta( get_the_ID(), 'pencibm_country', true );
					$flag_img = 'https://flagcdn.com/w160/' . strtolower( $country ) . '.png';
					?>
                    <div class="penci-prankings-item card-player"
                         data-name="<?php echo strtolower( get_post_meta( get_the_ID(), 'pencibm_fname', true ) ); ?>"
                         data-country="<?php echo strtolower( $country ); ?>">

                        <a href="<?php the_permalink(); ?>" class="penci-prankings-item-inner">

                            <div class="player-image">
								<?php
								if ( has_post_thumbnail() ) {
									echo get_the_post_thumbnail( get_the_ID(), 'penci-masonry-thumb' );
								} else {
									echo penci_player_rankings_df_ava();
								}
								?>
                                <div class="player-image-content">
                                    <div class="flag"><img
                                                src="<?php echo esc_url( $flag_img ); ?>"
                                                alt="" class="img-flag"></div>
                                    <div class="rank"><span>#</span><?php echo $player_count; ?></div>
                                </div>
                                <div class="rank-band"></div>
                            </div>

                            <div class="player-bio">
                                <div class="title">
                                    <span class="first"><?php echo get_post_meta( get_the_ID(), 'pencibm_fname', true ); ?></span>
                                    <span class="last"><?php echo get_post_meta( get_the_ID(), 'pencibm_lname', true ); ?></span>
                                </div>
                                <div class="icon-container"><span class="icon icon-linkarrow"></span></div>
                            </div>

                        </a>

                    </div>
					<?php
					$player_count ++;
				endwhile;
				wp_reset_postdata();
				?>
            </div>
			<?php
			penci_soledad_pagination();
		endif; ?>
    </div>
<?php
get_footer();
?>